/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.runtime;

import com.cloudimpl.outstack.runtime.EntityQueryContext;
import com.cloudimpl.outstack.runtime.EntityQueryContextProvider;
import com.cloudimpl.outstack.runtime.Handler;
import com.cloudimpl.outstack.runtime.QueryException;
import com.cloudimpl.outstack.runtime.domainspec.DomainEventException;
import com.cloudimpl.outstack.runtime.domainspec.Entity;
import com.cloudimpl.outstack.runtime.domainspec.IQuery;
import com.cloudimpl.outstack.runtime.domainspec.Query;
import com.cloudimpl.outstack.runtime.domainspec.TenantRequirement;
import com.cloudimpl.outstack.runtime.util.Util;

public abstract class EntityQueryHandler<T extends Entity, I extends Query, R>
implements Handler<T> {
    protected final Class<T> entityType;
    protected final Class<I> queryType;

    public EntityQueryHandler() {
        this.entityType = Util.extractGenericParameter(this.getClass(), EntityQueryHandler.class, 0);
        this.queryType = Util.extractGenericParameter(this.getClass(), EntityQueryHandler.class, 1);
    }

    public EntityQueryHandler(Class<T> entityType) {
        this.entityType = entityType;
        this.queryType = Util.extractGenericParameter(this.getClass(), EntityQueryHandler.class, 1);
    }

    public TenantRequirement getTenantFunction() {
        return Entity.checkTenantRequirement(this.entityType);
    }

    public R apply(EntityQueryContext<T> context, I query) {
        this.validateInput(query);
        return this.execute(context, query);
    }

    protected abstract R execute(EntityQueryContext<T> var1, I var2);

    protected void validateInput(I query) {
        if (this.getTenantFunction() == TenantRequirement.REQUIRED && ((Query)query).tenantId() == null) {
            throw new QueryException("tenantId is not available in the request", new Object[0]);
        }
    }

    public R emit(EntityQueryContextProvider contextProvider, IQuery input) {
        if (!contextProvider.getVersion().equals(input.version())) {
            throw new DomainEventException(DomainEventException.ErrorCode.INVALID_VERSION, "invalid version {0} ,expecting {1}", input.version(), contextProvider.getVersion());
        }
        I query = input.unwrap(this.queryType);
        this.validateInput(query);
        EntityQueryContextProvider.ReadOnlyTransaction tx = contextProvider.createTransaction(((Query)query).rootId(), this.getTenantFunction() == TenantRequirement.NONE ? null : ((Query)query).tenantId(), false);
        Object context = tx.getContext(this.entityType);
        return this.apply((EntityQueryContext<T>)context, query);
    }
}

