/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.runtime;

import com.cloudimpl.outstack.runtime.EntityCheckpoint;
import com.cloudimpl.outstack.runtime.EventRepositoryFactory;
import com.cloudimpl.outstack.runtime.ITransaction;
import com.cloudimpl.outstack.runtime.QueryOperations;
import com.cloudimpl.outstack.runtime.ResourceCache;
import com.cloudimpl.outstack.runtime.ResourceHelper;
import com.cloudimpl.outstack.runtime.common.StreamProcessor;
import com.cloudimpl.outstack.runtime.domainspec.ChildEntity;
import com.cloudimpl.outstack.runtime.domainspec.Entity;
import com.cloudimpl.outstack.runtime.domainspec.EntityHelper;
import com.cloudimpl.outstack.runtime.domainspec.Event;
import com.cloudimpl.outstack.runtime.domainspec.RootEntity;
import com.cloudimpl.outstack.runtime.repo.SimpleTransaction;
import com.cloudimpl.outstack.runtime.repo.StreamEvent;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public abstract class EventRepositoy<T extends RootEntity>
implements QueryOperations<T> {
    public static final String TID_PREFIX = "id-";
    protected final Class<T> rootType;
    private final StreamProcessor<StreamEvent> eventStream;
    private final ResourceCache<? extends Entity> mapStableCache;
    private final ResourceCache<EntityCheckpoint> mapTxCheckpoints;
    private final ThreadLocal<Map<String, EntityCheckpoint>> mapTxDirtyCheckpoints;
    protected final ResourceHelper resourceHelper;
    protected final String version;

    public EventRepositoy(Class<T> rootType, ResourceHelper resourceHelper) {
        this.rootType = rootType;
        this.version = Entity.getVersion(rootType);
        this.mapTxDirtyCheckpoints = ThreadLocal.withInitial(() -> new ConcurrentHashMap());
        this.resourceHelper = resourceHelper;
        this.mapStableCache = new ResourceCache(1000, Duration.ofHours(1L));
        this.mapTxCheckpoints = new ResourceCache(1000, Duration.ofHours(1L));
        this.eventStream = EventRepositoryFactory.eventStream;
    }

    public void saveTx(ITransaction<T> tx) {
        List<Event> eventList = tx.getEventList();
        if (eventList.isEmpty()) {
            return;
        }
        this.startTransaction();
        eventList.stream().peek(e -> e.setSeqNum(this.nextSeq(e.getRootEntityTRN()))).forEach(e -> this.addEvent((Event)e));
        long latestSeq = eventList.get(eventList.size() - 1).getSeqNum();
        tx.getEntityList().stream().forEach(e -> {
            if (e.isRoot()) {
                if (e.getMeta().getLastSeq() == 0L) {
                    EntityHelper.setLastEq(e, latestSeq);
                    this.saveRootEntityTrnIfNotExist((RootEntity)e);
                    this.saveRootEntityBrnIfNotExist((RootEntity)e);
                } else {
                    long seq = e.getMeta().getLastSeq();
                    EntityHelper.setLastEq(e, latestSeq);
                    if (tx.isEntityRenamed(e.getTRN())) {
                        this.saveRootEntityTrnIfExist(seq, (RootEntity)e);
                        this.saveRootEntityBrnIfNotExist((RootEntity)e);
                    } else {
                        this.saveRootEntityTrnIfExist(seq, (RootEntity)e);
                        this.saveRootEntityBrnIfExist(seq, (RootEntity)e);
                    }
                }
            } else {
                ChildEntity child = (ChildEntity)e;
                if (child.getMeta().getLastSeq() == 0L) {
                    EntityHelper.setLastEq(child, latestSeq);
                    this.saveChildEntityTrnIfNotExist(child);
                    this.saveChildEntityBrnIfNotExist(child);
                } else {
                    long seq = e.getMeta().getLastSeq();
                    EntityHelper.setLastEq(child, latestSeq);
                    if (tx.isEntityRenamed(e.getTRN())) {
                        this.saveChildEntityTrnIfExist(seq, child);
                        this.saveChildEntityBrnIfNotExist(child);
                    } else {
                        this.saveChildEntityTrnIfExist(seq, child);
                        this.saveChildEntityBrnIfExist(seq, child);
                    }
                }
            }
        });
        tx.getDeletedEntities().values().forEach(e -> {
            if (e.isRoot()) {
                this.deleteRootEntityBrnById((RootEntity)e, tx.isEntityRenamed(e.getTRN()));
            } else {
                ChildEntity child = (ChildEntity)e;
                this.deleteChildEntityBrnById(child, tx.isEntityRenamed(e.getTRN()));
            }
        });
        this.mapTxDirtyCheckpoints.get().values().forEach(checkpoint -> this.updateCheckpoint((EntityCheckpoint)checkpoint));
        try {
            this.endTransaction();
            this.mapTxDirtyCheckpoints.get().entrySet().forEach(ck -> this.mapTxCheckpoints.put(((EntityCheckpoint)ck.getValue()).getRootTrn(), (EntityCheckpoint)ck.getValue()));
            this.publishToStream(tx);
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            this.mapTxDirtyCheckpoints.get().clear();
        }
    }

    private void publishToStream(ITransaction<T> tx) {
        tx.getDeletedEntities().values().forEach(e -> this.eventStream.add(new StreamEvent(StreamEvent.Action.REMOVE, e)));
        tx.getEntityList().forEach(e -> this.eventStream.add(new StreamEvent(StreamEvent.Action.ADD, e)));
    }

    public <T extends Entity> T applyEvent(Event event) {
        SimpleTransaction transaction = new SimpleTransaction(event.getRootOwner(), this);
        transaction.apply(event);
        this.saveTx(transaction);
        return (T)transaction.getEntityList().iterator().next();
    }

    private long nextSeq(String rootTrn) {
        EntityCheckpoint checkpoint = this.getCheckpoint(rootTrn);
        long seq = checkpoint.nextSeq();
        this.mapTxDirtyCheckpoints.get().put(rootTrn, checkpoint);
        return seq;
    }

    protected EntityCheckpoint getCheckpoint(String rootTrn) {
        return Optional.ofNullable(this.mapTxDirtyCheckpoints.get().get(rootTrn)).or(() -> this.mapTxCheckpoints.get(rootTrn)).or(() -> this._getCheckpoint(rootTrn)).get();
    }

    protected abstract void startTransaction();

    protected abstract void endTransaction();

    protected abstract void saveRootEntityBrnIfNotExist(RootEntity var1);

    protected abstract void saveRootEntityTrnIfNotExist(RootEntity var1);

    protected abstract void saveRootEntityBrnIfExist(long var1, RootEntity var3);

    protected abstract void saveRootEntityTrnIfExist(long var1, RootEntity var3);

    protected abstract void saveChildEntityBrnIfNotExist(ChildEntity var1);

    protected abstract void saveChildEntityTrnIfNotExist(ChildEntity var1);

    protected abstract void saveChildEntityBrnIfExist(long var1, ChildEntity var3);

    protected abstract void saveChildEntityTrnIfExist(long var1, ChildEntity var3);

    protected abstract void deleteRootEntityBrnById(RootEntity var1, boolean var2);

    protected abstract void deleteRootEntityTrnById(Class<T> var1, String var2, String var3);

    protected abstract <C extends ChildEntity<T>> void deleteChildEntityBrnById(ChildEntity var1, boolean var2);

    protected abstract <C extends ChildEntity<T>> void deleteChildEntityTrnById(Class<T> var1, String var2, Class<C> var3, String var4, String var5);

    protected abstract Optional<EntityCheckpoint> _getCheckpoint(String var1);

    protected abstract void updateCheckpoint(EntityCheckpoint var1);

    protected abstract void addEvent(Event var1);

    public String generateTid() {
        return TID_PREFIX + UUID.randomUUID().toString();
    }

    public <K extends Entity, C extends ChildEntity<T>> Optional<K> loadEntityWithClone(Class<T> rootType, String id, Class<C> childType, String childId, String tenantId) {
        if (childType == null) {
            return this.getRootById(rootType, id, tenantId).map(e -> e.cloneEntity());
        }
        return this.getChildById(rootType, id, childType, childId, tenantId).map(e -> e.cloneEntity());
    }

    protected String resourcePrefix(String prefix) {
        return MessageFormat.format("{0}:{1}", prefix, this.resourceHelper);
    }
}

