/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.runtime;

import com.cloudimpl.outstack.runtime.EntityMetaDetailCache;
import com.cloudimpl.outstack.runtime.domain.ServiceModule;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.time.Duration;
import java.util.Optional;

public class ResourceCache<T> {
    private final Cache<String, Object> map;

    public ResourceCache(int maxSize, Duration evictionDuration) {
        this.map = Caffeine.newBuilder().maximumSize((long)maxSize).expireAfterAccess(evictionDuration).build();
    }

    public void put(String id, T resource) {
        this.map.put((Object)id, resource);
    }

    public <T> Optional<T> get(String id) {
        return Optional.ofNullable(this.map.getIfPresent((Object)id));
    }

    public <T> T get(String id, T given) {
        return (T)this.map.get((Object)id, i -> given);
    }

    public <T> Optional<T> remove(String id) {
        Optional<Object> optional = Optional.ofNullable(this.map.getIfPresent((Object)id));
        this.map.invalidate((Object)id);
        return optional;
    }

    public static void main(String[] args) {
        int i;
        long start = System.currentTimeMillis();
        for (i = 0; i < 100000000; ++i) {
            EntityMetaDetailCache.instance().getEntityMeta(ServiceModule.class);
        }
        long end = System.currentTimeMillis();
        System.out.println((end - start) / (long)i);
    }
}

