/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.runtime;

import com.cloudimpl.outstack.runtime.domainspec.IResource;
import java.text.MessageFormat;

public class ResourceHelper {
    private final String domainOwner;
    private final String domainContext;
    private final String apiContext;

    public ResourceHelper(String domainOwner, String domainContext, String apiContext) {
        this.domainOwner = domainOwner;
        this.domainContext = domainContext;
        this.apiContext = apiContext;
    }

    public String getFQBrn(IResource resource) {
        return MessageFormat.format("brn:{0}:{1}:{2}", this.domainOwner, this.domainContext, resource.getBRN());
    }

    public String getFQTrn(IResource resource) {
        return MessageFormat.format("trn:{0}:{1}:{2}", this.domainOwner, this.domainContext, resource.getTRN());
    }

    public String getFQBrn(String rn) {
        return MessageFormat.format("brn:{0}:{1}:{2}", this.domainOwner, this.domainContext, rn);
    }

    public String getFQTrn(String trn) {
        return MessageFormat.format("trn:{0}:{1}:{2}", this.domainOwner, this.domainContext, trn);
    }

    public String getDomainContext() {
        return this.domainContext;
    }

    public String getDomainOwner() {
        return this.domainOwner;
    }

    public String getApiContext() {
        return this.apiContext;
    }

    public String toString() {
        return MessageFormat.format("{0}:{1}", this.domainOwner, this.domainContext);
    }
}

