/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.runtime;

import com.cloudimpl.outstack.runtime.common.GsonCodecRuntime;
import com.google.gson.internal.LinkedTreeMap;
import java.util.Collection;
import java.util.stream.Collectors;

public class ResultSet<T> {
    private final long totalItems;
    private final int totalPages;
    private final int currentPage;
    private final Collection<T> items;

    public ResultSet(long totalItems, int totalPages, int currentPage, Collection<T> items) {
        this.totalItems = totalItems;
        this.totalPages = totalPages;
        this.currentPage = currentPage;
        this.items = items;
    }

    public long getTotalItems() {
        return this.totalItems;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    @Deprecated
    public Collection<T> getItems() {
        return this.items;
    }

    public Collection<T> getItems(Class<T> cls) {
        return this.items.stream().map(i -> {
            if (i instanceof LinkedTreeMap) {
                return GsonCodecRuntime.decodeTree(cls, (LinkedTreeMap)i);
            }
            return i;
        }).collect(Collectors.toList());
    }
}

