/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.runtime;

import com.cloudimpl.outstack.runtime.AsyncEntityCommandHandler;
import com.cloudimpl.outstack.runtime.CommandException;
import com.cloudimpl.outstack.runtime.CommandWrapper;
import com.cloudimpl.outstack.runtime.EntityCommandHandler;
import com.cloudimpl.outstack.runtime.EntityContext;
import com.cloudimpl.outstack.runtime.EntityContextProvider;
import com.cloudimpl.outstack.runtime.EntityEventHandler;
import com.cloudimpl.outstack.runtime.EventHandlerManager;
import com.cloudimpl.outstack.runtime.EventRepositoy;
import com.cloudimpl.outstack.runtime.ITransaction;
import com.cloudimpl.outstack.runtime.QueryOperations;
import com.cloudimpl.outstack.runtime.ServiceProviderException;
import com.cloudimpl.outstack.runtime.UnboundedCommandHandler;
import com.cloudimpl.outstack.runtime.common.GsonCodecRuntime;
import com.cloudimpl.outstack.runtime.domainspec.ChildEntity;
import com.cloudimpl.outstack.runtime.domainspec.Entity;
import com.cloudimpl.outstack.runtime.domainspec.Event;
import com.cloudimpl.outstack.runtime.domainspec.ICommand;
import com.cloudimpl.outstack.runtime.domainspec.RootEntity;
import com.cloudimpl.outstack.runtime.handler.DefaultDeleteCommandHandler;
import com.cloudimpl.outstack.runtime.handler.DefaultRenameCommandHandler;
import com.cloudimpl.outstack.runtime.util.Util;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.internal.LinkedTreeMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ServiceProvider<T extends RootEntity, R>
implements Function<Object, Publisher<?>> {
    private final Map<String, EntityCommandHandler> mapCmdHandlers = new HashMap<String, EntityCommandHandler>();
    private final EventHandlerManager evtHandlerManager;
    private final Class<T> rootType;
    private final EventRepositoy<T> eventRepository;
    private final EntityContextProvider<T> contextProvider;
    private static final ObjectMapper objectMapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL);
    private final Supplier<Consumer> injector;

    public ServiceProvider(Class<T> rootType, EventRepositoy<T> eventRepository, Function<Class<? extends RootEntity>, QueryOperations<?>> queryOperationSelector, Supplier<BiFunction<String, Object, Mono>> requestHandler, Supplier<Consumer> injector) {
        this.rootType = rootType;
        this.evtHandlerManager = new EventHandlerManager<T>(rootType);
        this.eventRepository = eventRepository;
        this.injector = injector;
        this.contextProvider = new EntityContextProvider<T>(rootType, this.eventRepository::loadEntityWithClone, eventRepository::generateTid, eventRepository, queryOperationSelector, requestHandler);
    }

    public void registerCommandHandler(Class<? extends EntityCommandHandler> handlerType) {
        ServiceProvider.validateHandler(handlerType.getSimpleName().toLowerCase(), this.rootType, Util.extractGenericParameter(handlerType, EntityCommandHandler.class, 0));
        EntityCommandHandler handler = Util.createObject(handlerType, new Util.VarArg(new Class[0]), new Util.VarArg<Object>(new Object[0]));
        this.injector.get().accept(handler);
        EntityCommandHandler exist = this.mapCmdHandlers.putIfAbsent(handlerType.getSimpleName().toLowerCase(), handler);
        if (exist != null) {
            throw new ServiceProviderException("commad handler {0} already exist ", handlerType.getSimpleName());
        }
    }

    public void registerDefaultCmdHandlersForEntity(Class<? extends Entity> entityType) {
        ServiceProvider.validateHandler("defaultCommandHandlers", this.rootType, entityType);
        EntityCommandHandler handler = Util.createObject(DefaultDeleteCommandHandler.class, new Util.VarArg(entityType.getClass()), new Util.VarArg<Object>(entityType));
        this.injector.get().accept(handler);
        this.mapCmdHandlers.computeIfAbsent(("Delete" + entityType.getSimpleName()).toLowerCase(), s -> handler);
        EntityCommandHandler handler2 = Util.createObject(DefaultRenameCommandHandler.class, new Util.VarArg(entityType.getClass()), new Util.VarArg<Object>(entityType));
        this.injector.get().accept(handler2);
        this.mapCmdHandlers.computeIfAbsent(("Rename" + entityType.getSimpleName()).toLowerCase(), s -> handler2);
    }

    public void registerEventHandler(Class<? extends EntityEventHandler> handlerType) {
        this.evtHandlerManager.register(handlerType);
    }

    public Optional<EntityCommandHandler> getCmdHandler(String name) {
        return Optional.ofNullable(this.mapCmdHandlers.get(name.toLowerCase()));
    }

    public static void validateHandler(String name, Class<? extends RootEntity> rootType, Class<? extends Entity> type) {
        if (RootEntity.isMyType(type)) {
            if (type != rootType) {
                throw new ServiceProviderException("handler {0} root entity type {1} not matched with service provider type {2}", name, type.getName(), rootType.getName());
            }
        } else {
            Class root = Util.extractGenericParameter(type, ChildEntity.class, 0);
            if (root != rootType) {
                throw new ServiceProviderException("handler {0} root entity type {1} not matched with service provider type {2}", name, root.getName(), rootType.getName());
            }
        }
    }

    @Override
    public Publisher apply(Object input) {
        if (ICommand.class.isInstance(input)) {
            return this.applyCommand((ICommand)input);
        }
        if (LinkedTreeMap.class.isInstance(input)) {
            return this.applyCommand(GsonCodecRuntime.decodeTree(CommandWrapper.class, (LinkedTreeMap)input));
        }
        return Mono.error(() -> new CommandException("invalid input received. {0}", input));
    }

    private Publisher applyCommand(ICommand cmd) {
        try {
            EntityCommandHandler handler = this.getCmdHandler(cmd.commandName()).orElseThrow(() -> new CommandException("command {0} not found", cmd.commandName().toLowerCase()));
            if (AsyncEntityCommandHandler.class.isInstance(handler)) {
                Mono mono = ((AsyncEntityCommandHandler)AsyncEntityCommandHandler.class.cast(handler)).emitAsync(this.contextProvider, cmd);
                return mono.doOnNext(ct -> this.evtHandlerManager.emit((EntityContextProvider.Transaction)ct.getTx(), ct.getEvents())).doOnNext(ct -> this.eventRepository.saveTx(ct.getTx())).flatMap(ct -> this.resolveReply(ct.getTx().getReply())).map(r -> this.encode(cmd, r)).doOnError(e -> ((Throwable)e).printStackTrace());
            }
            if (UnboundedCommandHandler.class.isInstance(handler)) {
                return ((UnboundedCommandHandler)UnboundedCommandHandler.class.cast(handler)).emitAsync(this.contextProvider, cmd).flatMap(ct -> Flux.fromIterable(((EntityContext)ct).getTx().getTxList()).doOnNext(tx -> this.evtHandlerManager.emit((EntityContextProvider.Transaction)tx, ((EntityContextProvider.Transaction)tx).getEventList())).doOnNext(tx -> this.eventRepository.saveTx((ITransaction)tx)).collectList().map(list -> ct)).flatMap(ct -> this.resolveReply(((EntityContext)ct).getTx().getReply())).map(r -> this.encode(cmd, r)).doOnError(e -> ((Throwable)e).printStackTrace());
            }
            return Mono.just(handler.emit(this.contextProvider, cmd)).doOnNext(ct -> this.evtHandlerManager.emit((EntityContextProvider.Transaction)ct.getTx(), ct.getEvents())).doOnNext(ct -> this.eventRepository.saveTx(ct.getTx())).flatMap(ct -> this.resolveReply(ct.getTx().getReply())).map(r -> this.encode(cmd, r)).doOnError(e -> ((Throwable)e).printStackTrace());
        }
        catch (Throwable thr) {
            thr.printStackTrace();
            return Mono.error((Throwable)thr);
        }
    }

    private Mono resolveReply(Object reply) {
        if (Mono.class.isInstance(reply)) {
            return (Mono)reply;
        }
        return Mono.just((Object)reply);
    }

    private Object encode(ICommand cmd, Object reply) {
        if (CommandWrapper.class.isInstance(cmd)) {
            Object ret = objectMapper.convertValue(reply, LinkedHashMap.class);
            return ret;
        }
        return reply;
    }

    public void applyEvent(Event event) {
        EntityContextProvider.Transaction<T> tx = this.contextProvider.createWritableTransaction(event.rootId(), event.tenantId(), false);
        this.evtHandlerManager.emit(tx, Collections.singletonList(event));
        this.eventRepository.saveTx(tx);
    }

    public void validate(Predicate<String> pred, String name, String error) {
        if (pred.test(name)) {
            throw new ServiceProviderException(error, new Object[0]);
        }
    }
}

