/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.runtime.configs;

import com.cloudimpl.outstack.runtime.configs.ConfigCreated;
import com.cloudimpl.outstack.runtime.configs.ConfigGroupEntity;
import com.cloudimpl.outstack.runtime.configs.ConfigUpdated;
import com.cloudimpl.outstack.runtime.domainspec.ChildEntity;
import com.cloudimpl.outstack.runtime.domainspec.DomainEventException;
import com.cloudimpl.outstack.runtime.domainspec.EntityMeta;
import com.cloudimpl.outstack.runtime.domainspec.Event;
import com.cloudimpl.outstack.runtime.domainspec.ITenantOptional;
import com.cloudimpl.outstack.runtime.domainspec.Id;

@EntityMeta(plural="config-entities", version="v1")
public class ConfigEntity
extends ChildEntity<ConfigGroupEntity>
implements ITenantOptional {
    @Id
    private final String configName;
    private String configValue;
    private final String tenantId;
    private String configType;

    public ConfigEntity(String configName, String tenantId) {
        this.configName = configName;
        this.tenantId = tenantId;
    }

    public String getConfigName() {
        return this.configName;
    }

    public String getConfigType() {
        return this.configType;
    }

    public String getConfigValue() {
        return this.configValue;
    }

    @Override
    public Class<ConfigGroupEntity> rootType() {
        return ConfigGroupEntity.class;
    }

    @Override
    public String entityId() {
        return this.configName;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    private void applyEvent(ConfigCreated configCreated) {
        this.configValue = configCreated.getConfigValue();
        this.configType = configCreated.getConfigType();
    }

    private void applyEvent(ConfigUpdated configUpdated) {
        this.configValue = configUpdated.getConfigValue();
        this.configType = configUpdated.getConfigType();
    }

    @Override
    protected void apply(Event event) {
        switch (event.getClass().getSimpleName()) {
            case "ConfigCreated": {
                this.applyEvent((ConfigCreated)event);
                break;
            }
            case "ConfigUpdated": {
                this.applyEvent((ConfigUpdated)event);
                break;
            }
            default: {
                throw new DomainEventException(DomainEventException.ErrorCode.UNHANDLED_EVENT, "unhandled event:" + event.getClass().getName(), new Object[0]);
            }
        }
    }

    @Override
    public String idField() {
        return "configName";
    }
}

