/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.runtime.domain;

import com.cloudimpl.outstack.runtime.domain.PolicyCreated;
import com.cloudimpl.outstack.runtime.domain.PolicyUpdated;
import com.cloudimpl.outstack.runtime.domainspec.DomainEventException;
import com.cloudimpl.outstack.runtime.domainspec.EntityMeta;
import com.cloudimpl.outstack.runtime.domainspec.Event;
import com.cloudimpl.outstack.runtime.domainspec.ITenantOptional;
import com.cloudimpl.outstack.runtime.domainspec.Id;
import com.cloudimpl.outstack.runtime.domainspec.RootEntity;
import java.util.Collections;
import java.util.List;

@EntityMeta(plural="Policies", version="v1")
public class Policy
extends RootEntity
implements ITenantOptional {
    private String policyContext;
    @Id
    private final String policyName;
    private final String tenantId;
    private String domainOwner;
    private String domainContext;
    private String apiContext;
    private List<String> dependentPolicies = Collections.EMPTY_LIST;
    private String boundary;

    public Policy(String policyName, String tenantId) {
        this.policyName = policyName;
        this.tenantId = tenantId;
    }

    public String getPolicyName() {
        return this.policyName;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public String entityId() {
        return this.policyName;
    }

    public String getPolicyContext() {
        return this.policyContext;
    }

    public String getDomainOwner() {
        return this.domainOwner;
    }

    public String getDomainContext() {
        return this.domainContext;
    }

    public String getApiContext() {
        return this.apiContext;
    }

    public String getBoundary() {
        return this.boundary;
    }

    public List<String> getDependentPolicies() {
        return this.dependentPolicies == null ? Collections.emptyList() : this.dependentPolicies;
    }

    private void applyEvent(PolicyCreated policyCreated) {
        this.policyContext = policyCreated.getPolicyContext();
        this.domainContext = policyCreated.getDomainContext();
        this.domainOwner = policyCreated.getDomainOwner();
        this.apiContext = policyCreated.getApiContext();
        this.boundary = policyCreated.getBoundary();
        this.dependentPolicies = policyCreated.getDependentPolicies();
    }

    private void applyEvent(PolicyUpdated policyUpdated) {
        this.policyContext = policyUpdated.getPolicyContext();
        this.domainContext = policyUpdated.getDomainContext();
        this.domainOwner = policyUpdated.getDomainOwner();
        this.apiContext = policyUpdated.getApiContext();
        this.boundary = policyUpdated.getBoundary();
        this.dependentPolicies = policyUpdated.getDependentPolicies();
    }

    @Override
    protected void apply(Event event) {
        switch (event.getClass().getSimpleName()) {
            case "PolicyCreated": {
                this.applyEvent((PolicyCreated)event);
                break;
            }
            case "PolicyUpdated": {
                this.applyEvent((PolicyUpdated)event);
                break;
            }
            default: {
                throw new DomainEventException(DomainEventException.ErrorCode.UNHANDLED_EVENT, "unhandled event:" + event.getClass().getName(), new Object[0]);
            }
        }
    }

    @Override
    public String idField() {
        return "policyName";
    }
}

