/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.runtime.domain;

import com.cloudimpl.outstack.runtime.domainspec.Command;
import java.util.List;

public class PolicyCreateRequest
extends Command {
    private final String domainOwner;
    private final String domainContext;
    private final String policyName;
    private final String policyContext;
    private final String boundary;
    private final List<String> dependentPolicies;

    public PolicyCreateRequest(Builder builder) {
        super(builder);
        this.domainOwner = builder.domainOwner;
        this.domainContext = builder.domainContext;
        this.policyName = builder.policyName;
        this.policyContext = builder.policyContext;
        this.boundary = builder.boundary;
        this.dependentPolicies = builder.dependentPolicies;
    }

    public String getPolicyName() {
        return this.policyName;
    }

    public String getPolicyContext() {
        return this.policyContext;
    }

    public String getDomainOwner() {
        return this.domainOwner;
    }

    public String getDomainContext() {
        return this.domainContext;
    }

    public String getBoundary() {
        return this.boundary;
    }

    public List<String> getDependentPolicies() {
        return this.dependentPolicies;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends Command.Builder {
        private String policyName;
        private String policyContext;
        private String domainOwner;
        private String domainContext;
        private String boundary;
        private List<String> dependentPolicies;

        public Builder withPolicyContext(String policyContext) {
            this.policyContext = policyContext;
            return this;
        }

        public Builder withPolicyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public Builder withDomainOwner(String domainOwner) {
            this.domainOwner = domainOwner;
            return this;
        }

        public Builder withDomainContext(String domainContext) {
            this.domainContext = domainContext;
            return this;
        }

        public Builder withBoundary(String boundary) {
            this.boundary = boundary;
            return this;
        }

        public Builder WithDependentPolicies(List<String> dependentPolicies) {
            this.dependentPolicies = dependentPolicies;
            return this;
        }

        public PolicyCreateRequest build() {
            return new PolicyCreateRequest(this);
        }
    }
}

