/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.runtime.domain;

import com.cloudimpl.outstack.runtime.domain.PolicyRefCreated;
import com.cloudimpl.outstack.runtime.domain.Role;
import com.cloudimpl.outstack.runtime.domainspec.ChildEntity;
import com.cloudimpl.outstack.runtime.domainspec.DomainEventException;
import com.cloudimpl.outstack.runtime.domainspec.EntityMeta;
import com.cloudimpl.outstack.runtime.domainspec.Event;
import com.cloudimpl.outstack.runtime.domainspec.ITenantOptional;
import com.cloudimpl.outstack.runtime.domainspec.Id;

@EntityMeta(plural="PolicyRef", version="v1")
public class PolicyRef
extends ChildEntity<Role>
implements ITenantOptional {
    @Id
    private final String policyRef;
    private final String tenantId;
    private String domainContext;
    private String domainOwner;
    private String version;

    public PolicyRef(String policyRef, String tenantId) {
        this.policyRef = policyRef;
        this.tenantId = tenantId;
    }

    @Override
    public Class<Role> rootType() {
        return Role.class;
    }

    @Override
    public String entityId() {
        return this.policyRef;
    }

    public String getPolicyRef() {
        return this.policyRef;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    public String getDomainContext() {
        return this.domainContext;
    }

    public String getDomainOwner() {
        return this.domainOwner;
    }

    public String getVersion() {
        return this.version;
    }

    private void applyEvent(PolicyRefCreated event) {
        this.domainContext = event.getDomainContext();
        this.domainOwner = event.getDomainOwner();
        this.version = event.getVersion();
    }

    @Override
    protected void apply(Event event) {
        switch (event.getClass().getSimpleName()) {
            case "PolicyRefCreated": {
                this.applyEvent((PolicyRefCreated)event);
                break;
            }
            default: {
                throw new DomainEventException(DomainEventException.ErrorCode.UNHANDLED_EVENT, "unhandled event:" + event.getClass().getName(), new Object[0]);
            }
        }
    }

    @Override
    public String idField() {
        return "policyRef";
    }
}

