/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.runtime.domain;

import com.cloudimpl.outstack.runtime.common.GsonCodecRuntime;
import com.cloudimpl.outstack.runtime.domain.PolicyStatement;
import com.cloudimpl.outstack.runtime.domainspec.Command;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;

public class PolicyStatementRequest
extends Command {
    private final String sid;
    private final String domainOwner;
    private final String domainContext;
    private final String rootType;
    private final PolicyStatement.EffectType effect;
    private final Collection<String> cmdActions;
    private final Collection<String> queryActions;
    private final Collection<String> resources;
    private final Collection<String> tags;

    public PolicyStatementRequest(Builder builder) {
        super(builder);
        this.sid = builder.sid;
        this.domainOwner = builder.domainOwner;
        this.domainContext = builder.domainContext;
        this.rootType = builder.rootType;
        this.effect = builder.effect;
        this.cmdActions = Collections.unmodifiableCollection(builder.cmdActions);
        this.queryActions = Collections.unmodifiableCollection(builder.queryActions);
        this.resources = Collections.unmodifiableCollection(builder.resources);
        this.tags = Collections.unmodifiableCollection(builder.tags);
    }

    public Collection<String> getCmdActions() {
        return this.cmdActions;
    }

    public Collection<String> getQueryActions() {
        return this.queryActions;
    }

    public PolicyStatement.EffectType getEffect() {
        return this.effect;
    }

    public String getRootType() {
        return this.rootType;
    }

    public Collection<String> getTags() {
        return this.tags;
    }

    public Collection<String> getResources() {
        return this.resources;
    }

    public String getSid() {
        return this.sid;
    }

    public String getDomainContext() {
        return this.domainContext;
    }

    public String getDomainOwner() {
        return this.domainOwner;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static void main(String[] args) {
        String json = "{sid:ReadOnlyAccess,effect:ALLOW,actions:[GetTenant],resources:[\"v1/**\"]}";
        PolicyStatementRequest stmt = GsonCodecRuntime.decode(PolicyStatementRequest.class, json);
        System.out.println("");
    }

    public static final class Builder
    extends Command.Builder {
        private String sid;
        private String domainOwner;
        private String domainContext;
        private String rootType;
        private PolicyStatement.EffectType effect;
        private Collection<String> cmdActions = new LinkedList<String>();
        private Collection<String> queryActions = new LinkedList<String>();
        private Collection<String> resources = new LinkedList<String>();
        private Collection<String> tags = new LinkedList<String>();

        public Builder withSid(String sid) {
            this.sid = sid;
            return this;
        }

        public Builder withRootType(String rootType) {
            this.rootType = rootType;
            return this;
        }

        public Builder withEffect(PolicyStatement.EffectType type) {
            this.effect = type;
            return this;
        }

        public Builder withCmdAction(String action) {
            this.cmdActions.add(action);
            return this;
        }

        public Builder withQueryAction(String action) {
            this.queryActions.add(action);
            return this;
        }

        public Builder withResource(String resource) {
            this.resources.add(resource);
            return this;
        }

        public Builder withDomainContext(String domainContext) {
            this.domainContext = domainContext;
            return this;
        }

        public Builder withDomainOwner(String domainOwner) {
            this.domainOwner = domainOwner;
            return this;
        }

        public Builder withTag(String tag) {
            this.tags.add(tag);
            return this;
        }

        public PolicyStatementRequest build() {
            return new PolicyStatementRequest(this);
        }
    }
}

