/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.runtime.domain;

import com.cloudimpl.outstack.runtime.domain.PolicyStatement;
import com.cloudimpl.outstack.runtime.domainspec.Entity;
import com.cloudimpl.outstack.runtime.domainspec.Event;
import com.cloudimpl.outstack.runtime.domainspec.RootEntity;
import com.cloudimpl.outstack.runtime.iam.ActionDescriptor;
import com.cloudimpl.outstack.runtime.iam.ResourceDescriptor;
import java.util.Collection;

public class PolicyStatementUpdated
extends Event<PolicyStatement> {
    private final String sid;
    private final PolicyStatement.EffectType effect;
    private final Collection<ActionDescriptor> cmdActions;
    private final Collection<ActionDescriptor> queryActions;
    private final Collection<ResourceDescriptor> resources;

    public PolicyStatementUpdated(String sid, PolicyStatement.EffectType effect, Collection<ActionDescriptor> cmdActions, Collection<ActionDescriptor> queryActions, Collection<ResourceDescriptor> resources) {
        this.sid = sid;
        this.effect = effect;
        this.cmdActions = cmdActions;
        this.queryActions = queryActions;
        this.resources = resources;
    }

    public String getSid() {
        return this.sid;
    }

    public PolicyStatement.EffectType getEffect() {
        return this.effect;
    }

    public Collection<ActionDescriptor> getCmdActions() {
        return this.cmdActions;
    }

    public Collection<ActionDescriptor> getQueryActions() {
        return this.queryActions;
    }

    public Collection<ResourceDescriptor> getResources() {
        return this.resources;
    }

    public boolean isTenantStatement() {
        return this.getResources().stream().filter(r -> !r.isTenantResource()).findAny().isEmpty();
    }

    @Override
    public Class<? extends Entity> getOwner() {
        return PolicyStatement.class;
    }

    @Override
    public Class<? extends RootEntity> getRootOwner() {
        return PolicyStatement.class;
    }

    @Override
    public String entityId() {
        return this.sid;
    }

    @Override
    public String rootEntityId() {
        return this.sid;
    }
}

