/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.runtime.domain;

import com.cloudimpl.outstack.runtime.domain.QueryHandlerRegistered;
import com.cloudimpl.outstack.runtime.domain.ServiceModule;
import com.cloudimpl.outstack.runtime.domainspec.ChildEntity;
import com.cloudimpl.outstack.runtime.domainspec.DomainEventException;
import com.cloudimpl.outstack.runtime.domainspec.EntityMeta;
import com.cloudimpl.outstack.runtime.domainspec.Event;
import com.cloudimpl.outstack.runtime.domainspec.Id;

@EntityMeta(plural="QueryHandlers", version="v1")
public class QueryHandlerEntity
extends ChildEntity<ServiceModule> {
    @Id
    private String handlerName;
    private String entityName;

    public QueryHandlerEntity(String handlerName) {
        this.handlerName = handlerName;
    }

    public String getHandlerName() {
        return this.handlerName;
    }

    public String getEntityName() {
        return this.entityName;
    }

    @Override
    public Class<ServiceModule> rootType() {
        return ServiceModule.class;
    }

    @Override
    public String entityId() {
        return this.handlerName;
    }

    private void applyEvent(QueryHandlerRegistered queryHandlerRegistered) {
        this.handlerName = queryHandlerRegistered.getHandlerName();
        this.entityName = queryHandlerRegistered.getEntityName();
    }

    @Override
    protected void apply(Event event) {
        switch (event.getClass().getSimpleName()) {
            case "QueryHandlerRegistered": {
                this.applyEvent((QueryHandlerRegistered)event);
                break;
            }
            default: {
                throw new DomainEventException(DomainEventException.ErrorCode.UNHANDLED_EVENT, "unhandled event:" + event.getClass().getName(), new Object[0]);
            }
        }
    }

    @Override
    public String idField() {
        return "handlerName";
    }
}

