/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.runtime.domain;

import com.cloudimpl.outstack.runtime.domain.RoleCreated;
import com.cloudimpl.outstack.runtime.domainspec.DomainEventException;
import com.cloudimpl.outstack.runtime.domainspec.EntityMeta;
import com.cloudimpl.outstack.runtime.domainspec.Event;
import com.cloudimpl.outstack.runtime.domainspec.ITenantOptional;
import com.cloudimpl.outstack.runtime.domainspec.Id;
import com.cloudimpl.outstack.runtime.domainspec.RootEntity;

@EntityMeta(plural="Roles", version="v1")
public class Role
extends RootEntity
implements ITenantOptional {
    @Id
    private final String roleName;
    private final String tenantId;
    private String type;

    public Role(String roleName, String tenantId) {
        this.roleName = roleName;
        this.tenantId = tenantId;
    }

    public String getRoleName() {
        return this.roleName;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    public String getType() {
        return this.type;
    }

    @Override
    public String entityId() {
        return this.roleName;
    }

    private void applyEvent(RoleCreated created) {
        this.type = created.getType();
    }

    @Override
    protected void apply(Event event) {
        switch (event.getClass().getSimpleName()) {
            case "RoleCreated": {
                this.applyEvent((RoleCreated)event);
                break;
            }
            default: {
                throw new DomainEventException(DomainEventException.ErrorCode.UNHANDLED_EVENT, "unhandled event:" + event.getClass().getName(), new Object[0]);
            }
        }
    }

    @Override
    public String idField() {
        return "roleName";
    }
}

