/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.runtime.domain;

import com.cloudimpl.outstack.runtime.domain.ServiceModuleProvisioned;
import com.cloudimpl.outstack.runtime.domainspec.DomainEventException;
import com.cloudimpl.outstack.runtime.domainspec.EntityMeta;
import com.cloudimpl.outstack.runtime.domainspec.Event;
import com.cloudimpl.outstack.runtime.domainspec.Id;
import com.cloudimpl.outstack.runtime.domainspec.RootEntity;
import com.cloudimpl.outstack.runtime.domainspec.TenantRequirement;

@EntityMeta(plural="ServiceModules", version="v1")
public class ServiceModule
extends RootEntity {
    @Id
    private final String rootEntity;
    private String serviceName;
    private String version;
    private TenantRequirement tenancy;
    private String apiContext;

    public ServiceModule(String rootEntity) {
        this.rootEntity = rootEntity;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getVersion() {
        return this.version;
    }

    public TenantRequirement getTenancy() {
        return this.tenancy;
    }

    public String getApiContext() {
        return this.apiContext;
    }

    public String getRootEntity() {
        return this.rootEntity;
    }

    @Override
    public String entityId() {
        return this.rootEntity;
    }

    private void applyEvent(ServiceModuleProvisioned serviceModuleProvisioned) {
        this.serviceName = serviceModuleProvisioned.getServiceName();
        this.version = serviceModuleProvisioned.getVersion();
        this.tenancy = serviceModuleProvisioned.getTenancy();
        this.apiContext = serviceModuleProvisioned.getApiContext();
    }

    @Override
    protected void apply(Event event) {
        switch (event.getClass().getSimpleName()) {
            case "ServiceModuleProvisioned": {
                this.applyEvent((ServiceModuleProvisioned)event);
                break;
            }
            default: {
                throw new DomainEventException(DomainEventException.ErrorCode.UNHANDLED_EVENT, "unhandled event:" + event.getClass().getName(), new Object[0]);
            }
        }
    }

    @Override
    public String idField() {
        return "rootEntity";
    }
}

