/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.runtime.domainspec;

import com.cloudimpl.outstack.runtime.EntityMetaDetail;
import com.cloudimpl.outstack.runtime.EntityMetaDetailCache;
import com.cloudimpl.outstack.runtime.domainspec.Entity;
import com.cloudimpl.outstack.runtime.domainspec.ITenant;
import com.cloudimpl.outstack.runtime.domainspec.RootEntity;
import java.text.MessageFormat;
import java.util.Objects;

public abstract class ChildEntity<T extends RootEntity>
extends Entity {
    private String _rootId;

    public ChildEntity() {
        this._meta.setRootIdIgnoreCase(EntityMetaDetailCache.instance().getEntityMeta(this.rootType()).isIdIgnoreCase());
    }

    public final void setRootId(String rootId) {
        this._rootId = rootId;
    }

    public String rootId() {
        return this._rootId;
    }

    public abstract Class<T> rootType();

    @Override
    public String getTRN() {
        switch (this.getTenantRequirement()) {
            case REQUIRED: {
                Objects.requireNonNull(((ITenant)ITenant.class.cast(this)).getTenantId());
            }
            case OPTIONAL: {
                return ChildEntity.makeTRN(this.rootType(), this.getMeta().getVersion(), this.rootId(), this.getClass(), this.id(), this.getTenantId());
            }
        }
        return ChildEntity.makeTRN(this.rootType(), this.getMeta().getVersion(), this.rootId(), this.getClass(), this.id(), null);
    }

    public String getRootTRN() {
        switch (this.getTenantRequirement()) {
            case REQUIRED: {
                Objects.requireNonNull(((ITenant)ITenant.class.cast(this)).getTenantId());
            }
            case OPTIONAL: {
                return RootEntity.makeTRN(this.rootType(), this.getMeta().getVersion(), this.rootId(), this.getTenantId());
            }
        }
        return RootEntity.makeTRN(this.rootType(), this.getMeta().getVersion(), this.rootId(), null);
    }

    @Override
    public String getBRN() {
        switch (this.getTenantRequirement()) {
            case REQUIRED: {
                Objects.requireNonNull(((ITenant)ITenant.class.cast(this)).getTenantId());
            }
            case OPTIONAL: {
                return ChildEntity.makeRN(this.rootType(), this.getMeta().getVersion(), this.rootId(), this.getClass(), this.persistedId(), this.getTenantId());
            }
        }
        return ChildEntity.makeRN(this.rootType(), this.getMeta().getVersion(), this.rootId(), this.getClass(), this.persistedId(), null);
    }

    public static <R extends RootEntity, T extends ChildEntity<R>> String makeRN(Class<R> rootType, String version, String rootId, Class<T> childType, String entityId, String tenantId) {
        EntityMetaDetail meta = EntityMetaDetailCache.instance().getEntityMeta(childType);
        if (tenantId != null) {
            return MessageFormat.format("tenant/{0}/{1}/{2}/{3}/{4}/{5}", tenantId, version, rootType.getSimpleName(), rootId, childType.getSimpleName(), meta.isIdIgnoreCase() ? entityId.toLowerCase() : entityId);
        }
        return MessageFormat.format("{0}/{1}/{2}/{3}/{4}", version, rootType.getSimpleName(), rootId, childType.getSimpleName(), meta.isIdIgnoreCase() ? entityId.toLowerCase() : entityId);
    }

    public static <R extends RootEntity, T extends ChildEntity<R>> String makeTRN(Class<R> rootType, String version, String rootId, Class<T> childType, String id, String tenantId) {
        if (tenantId != null) {
            return MessageFormat.format("tenant/{0}/{1}/{2}/{3}/{4}/{5}", tenantId, version, rootType.getSimpleName(), rootId, childType.getSimpleName(), id);
        }
        return MessageFormat.format("{0}/{1}/{2}/{3}/{4}", version, rootType.getSimpleName(), rootId, childType.getSimpleName(), id);
    }
}

