/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.runtime.domainspec;

import com.cloudimpl.outstack.runtime.EntityMetaDetail;
import com.cloudimpl.outstack.runtime.EntityMetaDetailCache;
import com.cloudimpl.outstack.runtime.common.GsonCodecRuntime;
import com.cloudimpl.outstack.runtime.domainspec.DomainEventException;
import com.cloudimpl.outstack.runtime.domainspec.EntityHelper;
import com.cloudimpl.outstack.runtime.domainspec.EntityMeta;
import com.cloudimpl.outstack.runtime.domainspec.Event;
import com.cloudimpl.outstack.runtime.domainspec.IResource;
import com.cloudimpl.outstack.runtime.domainspec.ITenant;
import com.cloudimpl.outstack.runtime.domainspec.ITenantOptional;
import com.cloudimpl.outstack.runtime.domainspec.RootEntity;
import com.cloudimpl.outstack.runtime.domainspec.TenantRequirement;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.JsonObject;

public abstract class Entity
implements IResource,
Comparable<Entity> {
    @JsonProperty
    private String _id;
    protected final Meta _meta = new Meta();

    public Entity() {
        EntityMetaDetail meta = EntityMetaDetailCache.instance().getEntityMeta(this.getClass());
        this._meta.setVersion(meta.getVersion());
        this._meta.setIdIgnoreCase(meta.isIdIgnoreCase());
        this._meta.setRootIdIgnoreCase(meta.isIdIgnoreCase());
    }

    final void setTid(String id) {
        this._id = id;
    }

    public String persistedId() {
        EntityMetaDetail meta = EntityMetaDetailCache.instance().getEntityMeta(this.getClass());
        return meta.isIdIgnoreCase() ? this.entityId().toLowerCase() : this.entityId();
    }

    public final String id() {
        return this._id;
    }

    public abstract String entityId();

    @JsonProperty
    public final TenantRequirement getTenantRequirement() {
        if (ITenant.class.isInstance(this)) {
            return TenantRequirement.REQUIRED;
        }
        if (ITenantOptional.class.isInstance(this)) {
            return TenantRequirement.OPTIONAL;
        }
        return TenantRequirement.NONE;
    }

    public String getTenantId() {
        return null;
    }

    public final boolean isRoot() {
        return this instanceof RootEntity;
    }

    protected abstract void apply(Event var1);

    protected final void applyEvent(Event event) {
        if (event.getOwner() != this.getClass()) {
            throw new DomainEventException(DomainEventException.ErrorCode.INVALID_DOMAIN_EVENT, "invalid domain event: " + event.getClass().getName(), new Object[0]);
        }
        this.apply(event);
    }

    public <T extends Entity> T cloneEntity() {
        String json = GsonCodecRuntime.encode(this);
        return (T)((Entity)GsonCodecRuntime.decode(this.getClass(), json));
    }

    public <T extends Entity> T rename(String newEntityId) {
        JsonObject json = GsonCodecRuntime.encodeToJson(this).getAsJsonObject();
        json.addProperty(this.idField(), newEntityId);
        return (T)((Entity)GsonCodecRuntime.decode(this.getClass(), json.toString()));
    }

    public abstract String idField();

    public static void checkTenantEligibility(Class<? extends Entity> type, String tenantId) {
        if (EntityHelper.hasTenant(type) && tenantId == null) {
            throw new DomainEventException(DomainEventException.ErrorCode.TENANT_ID_NOT_AVAILABLE, "tenantId is null for entity creation", new Object[0]);
        }
        if (!EntityHelper.hasTenant(type) && !EntityHelper.hasOptionalTenant(type) && tenantId != null) {
            throw new DomainEventException(DomainEventException.ErrorCode.TENANT_ID_NOT_APPLICABLE, "tenantId is not applicable for entity creation", new Object[0]);
        }
    }

    public static TenantRequirement checkTenantRequirement(Class<? extends Entity> type) {
        if (ITenant.class.isAssignableFrom(type)) {
            return TenantRequirement.REQUIRED;
        }
        if (ITenantOptional.class.isAssignableFrom(type)) {
            return TenantRequirement.OPTIONAL;
        }
        return TenantRequirement.NONE;
    }

    public static boolean hasTenant(Class<? extends Entity> entityType) {
        return ITenant.class.isAssignableFrom(entityType);
    }

    public static String getVersion(Class<? extends Entity> entityType) {
        return entityType.getAnnotation(EntityMeta.class).version();
    }

    public final Meta getMeta() {
        return this._meta;
    }

    @Override
    public int compareTo(Entity o) {
        return this.id().compareTo(o.id());
    }

    public String toString() {
        return GsonCodecRuntime.encode(this);
    }

    public static final class Meta {
        private long createdDate;
        private long updatedDate;
        private long lastSeq;
        private String version;
        private boolean idIgnoreCase;
        private boolean rootIdIgnoreCase;
        private String userId;
        private String userName;

        protected void setCreatedDate(long createdDate) {
            this.createdDate = createdDate;
        }

        protected void setUpdatedDate(long updatedDate) {
            this.updatedDate = updatedDate;
        }

        protected void setVersion(String version) {
            this.version = version;
        }

        public long getCreatedDate() {
            return this.createdDate;
        }

        public long getUpdatedDate() {
            return this.updatedDate;
        }

        protected void setIdIgnoreCase(boolean idIgnoreCase) {
            this.idIgnoreCase = idIgnoreCase;
        }

        protected void setRootIdIgnoreCase(boolean rootIdIgnoreCase) {
            this.rootIdIgnoreCase = rootIdIgnoreCase;
        }

        public String getVersion() {
            return this.version;
        }

        public long getLastSeq() {
            return this.lastSeq;
        }

        public void setLastSeq(long lastSeq) {
            this.lastSeq = lastSeq;
        }

        public long createdDate() {
            return this.createdDate;
        }

        public long updatedDate() {
            return this.updatedDate;
        }

        public String getUserId() {
            return this.userId;
        }

        protected void setUserId(String userId) {
            this.userId = userId;
        }

        public String getUserName() {
            return this.userName;
        }

        protected void setUserName(String userName) {
            this.userName = userName;
        }
    }
}

