/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.runtime.domainspec;

import com.cloudimpl.outstack.runtime.EntityMetaDetail;
import com.cloudimpl.outstack.runtime.EntityMetaDetailCache;
import com.cloudimpl.outstack.runtime.domainspec.ChildEntity;
import com.cloudimpl.outstack.runtime.domainspec.Entity;
import com.cloudimpl.outstack.runtime.domainspec.EntityHelper;
import com.cloudimpl.outstack.runtime.domainspec.ITenant;
import com.cloudimpl.outstack.runtime.domainspec.TenantRequirement;
import com.cloudimpl.outstack.runtime.util.Util;
import java.text.MessageFormat;
import java.util.Objects;

public abstract class RootEntity
extends Entity {
    @Override
    public final String getBRN() {
        switch (this.getTenantRequirement()) {
            case REQUIRED: {
                Objects.requireNonNull(((ITenant)ITenant.class.cast(this)).getTenantId());
            }
            case OPTIONAL: {
                return RootEntity.makeRN(this.getClass(), this.getMeta().getVersion(), this.persistedId(), this.getTenantId());
            }
        }
        return RootEntity.makeRN(this.getClass(), this.getMeta().getVersion(), this.persistedId(), null);
    }

    @Override
    public final String getTRN() {
        switch (this.getTenantRequirement()) {
            case REQUIRED: {
                Objects.requireNonNull(((ITenant)ITenant.class.cast(this)).getTenantId());
            }
            case OPTIONAL: {
                return RootEntity.makeTRN(this.getClass(), this.getMeta().getVersion(), this.id(), this.getTenantId());
            }
        }
        return RootEntity.makeTRN(this.getClass(), this.getMeta().getVersion(), this.id(), null);
    }

    public <T extends ChildEntity> T createChildEntity(Class<T> type, String entityId, String id) {
        ChildEntity t = switch (this.getTenantRequirement()) {
            case TenantRequirement.REQUIRED -> {
                Objects.requireNonNull(((ITenant)ITenant.class.cast(this)).getTenantId());
                yield (ChildEntity)Util.createObject(type, new Util.VarArg(String.class, String.class), new Util.VarArg<Object>(entityId, ((ITenant)ITenant.class.cast(this)).getTenantId()));
            }
            case TenantRequirement.OPTIONAL -> (ChildEntity)Util.createObject(type, new Util.VarArg(String.class, String.class), new Util.VarArg<Object>(entityId, this.getTenantId()));
            default -> (ChildEntity)Util.createObject(type, new Util.VarArg(String.class), new Util.VarArg<Object>(entityId));
        };
        EntityHelper.updateId(t, id);
        EntityHelper.updateRootId(t, this.id());
        return (T)t;
    }

    public static <T extends RootEntity> T create(Class<T> type, String entityId, String tenantId, String tid) {
        RootEntity root;
        TenantRequirement req = RootEntity.checkTenantRequirement(type);
        switch (req) {
            case REQUIRED: {
                Objects.requireNonNull(tenantId);
            }
            case OPTIONAL: {
                root = (RootEntity)Util.createObject(type, new Util.VarArg(String.class, String.class), new Util.VarArg<Object>(entityId, tenantId));
                break;
            }
            default: {
                root = (RootEntity)Util.createObject(type, new Util.VarArg(String.class), new Util.VarArg<Object>(entityId));
            }
        }
        EntityHelper.updateId(root, tid);
        return (T)root;
    }

    public static boolean isMyType(Class<? extends Entity> type) {
        return RootEntity.class.isAssignableFrom(type);
    }

    public static String makeRN(Class<? extends RootEntity> type, String version, String entityId, String tenantId) {
        EntityMetaDetail meta = EntityMetaDetailCache.instance().getEntityMeta(type);
        if (tenantId != null) {
            return MessageFormat.format("tenant/{0}/{1}/{2}/{3}", tenantId, version, type.getSimpleName(), meta.isIdIgnoreCase() ? entityId.toLowerCase() : entityId);
        }
        return MessageFormat.format("{0}/{1}/{2}", version, type.getSimpleName(), meta.isIdIgnoreCase() ? entityId.toLowerCase() : entityId);
    }

    public static String makeTRN(Class<? extends RootEntity> type, String version, String id, String tenantId) {
        if (tenantId != null) {
            return MessageFormat.format("tenant/{0}/{1}/{2}/{3}", tenantId, version, type.getSimpleName(), id);
        }
        return MessageFormat.format("{0}/{1}/{2}", version, type.getSimpleName(), id);
    }
}

