/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.runtime.iam;

public class ActionDescriptor {
    private final String name;
    private final ActionScope actionScope;

    public ActionDescriptor(String name, ActionScope actionScope) {
        this.name = name;
        this.actionScope = actionScope;
    }

    public ActionScope getActionScope() {
        return this.actionScope;
    }

    public String getName() {
        return this.name;
    }

    public boolean isActionMatched(String action) {
        switch (this.actionScope) {
            case ALL: {
                return true;
            }
            case PREFIX_MATCH: {
                return action.toLowerCase().startsWith(this.name);
            }
            case EXACT_NAME: {
                return action.equalsIgnoreCase(this.name);
            }
        }
        return false;
    }

    public String toString() {
        return "ActionDescriptor{name=" + this.name + ", actionScope=" + this.actionScope + "}";
    }

    public static enum ActionScope {
        ALL,
        PREFIX_MATCH,
        EXACT_NAME;

    }
}

