/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.runtime.iam;

import com.cloudimpl.outstack.runtime.ResourceHelper;
import com.cloudimpl.outstack.runtime.RootEntityContext;
import com.cloudimpl.outstack.runtime.domain.CommandHandlerEntity;
import com.cloudimpl.outstack.runtime.domain.PolicyStatement;
import com.cloudimpl.outstack.runtime.domain.PolicyStatementCreated;
import com.cloudimpl.outstack.runtime.domain.PolicyStatementRequest;
import com.cloudimpl.outstack.runtime.domain.QueryHandlerEntity;
import com.cloudimpl.outstack.runtime.domain.ServiceModule;
import com.cloudimpl.outstack.runtime.domainspec.TenantRequirement;
import com.cloudimpl.outstack.runtime.iam.ActionDescriptor;
import com.cloudimpl.outstack.runtime.iam.PolicyStatementException;
import com.cloudimpl.outstack.runtime.iam.PolicyValidationError;
import com.cloudimpl.outstack.runtime.iam.ResourceDescriptor;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class PolicyStatementParser {
    public static Pattern RESOURCE_NAME_PATTERN = Pattern.compile("[a-zA-Z_$][a-zA-Z\\d_$]*");
    public static Pattern RESOURCE_ID_PATTERN = Pattern.compile("[a-zA-Z0-9_$][a-zA-Z0-9_-]*|\\{[a-zA-Z0-9_$][a-zA-Z0-9._-]*\\}");

    public static PolicyStatementCreated parseStatement(String domainOwner, String domainContext, PolicyStatementRequest stmt) {
        if (stmt.getEffect() == null) {
            throw new PolicyStatementException("policy statement effectType is null", new Object[0]);
        }
        PolicyStatementParser.validateResourceName(stmt.getSid(), "statmentID");
        Collection cmdActions = stmt.getCmdActions().stream().map(action -> PolicyStatementParser.parseAction(action)).collect(Collectors.toList());
        Collection queryActions = stmt.getQueryActions().stream().map(action -> PolicyStatementParser.parseAction(action)).collect(Collectors.toList());
        Collection resources = stmt.getResources().stream().map(resource -> PolicyStatementParser.parse(resource)).collect(Collectors.toList());
        if (resources.isEmpty()) {
            throw new PolicyStatementException("policy statement resources are empty", new Object[0]);
        }
        return new PolicyStatementCreated(stmt.getSid(), domainOwner, domainContext, stmt.getEffect(), cmdActions, queryActions, resources, stmt.getTags());
    }

    public static void validate(ResourceHelper resourceHelper, RootEntityContext<PolicyStatement> context, PolicyStatementCreated event) {
        String rootType = PolicyStatementParser.validateCrossResourceUsage(resourceHelper, context, event.getResources());
        if (rootType == null) {
            rootType = "*";
        }
        PolicyStatementParser.validateActions(resourceHelper, context, rootType, event.getCmdActions(), event.getQueryActions());
    }

    private static String validateCrossResourceUsage(ResourceHelper resourceHelper, RootEntityContext<PolicyStatement> context, Collection<ResourceDescriptor> resources) {
        String rootType = null;
        for (ResourceDescriptor desc : resources) {
            switch (desc.getResourceScope()) {
                case ALL: 
                case ALL_ROOT_ID_CHILD_ID_ONLY: 
                case ALL_ROOT_ID_CHILD_TYPE_ONLY: 
                case ALL_ROOT_ID_ONLY: 
                case ROOT_ID_CHILD_ID_ONLY: 
                case ROOT_ID_CHILD_TYPE_ONLY: 
                case ROOT_ID_ONLY: {
                    ServiceModule serviceModule = context.getEntityQueryProvider(ServiceModule.class).getRoot(resourceHelper.getDomainOwner() + ":" + resourceHelper.getDomainContext() + ":" + desc.getRootType()).orElseThrow(() -> new PolicyValidationError("resource " + desc.getRootType() + " not found"));
                    if (rootType == null) {
                        rootType = desc.getRootType();
                    } else if (!rootType.equalsIgnoreCase(desc.getRootType())) {
                        throw new PolicyValidationError("cross resources reference not allowed");
                    }
                    if (!serviceModule.getVersion().equals(desc.getVersion())) {
                        throw new PolicyValidationError("invalid resource version: " + desc.getVersion());
                    }
                    if (serviceModule.getTenancy() == TenantRequirement.REQUIRED && !desc.isTenantResource()) {
                        throw new PolicyValidationError(rootType + " is a tenant resource, non tenant resource pattern not allowed");
                    }
                    if (serviceModule.getTenancy() != TenantRequirement.NONE || !desc.isTenantResource()) break;
                    throw new PolicyValidationError(rootType + " is a non tenant resource, tenant resource pattern not allowed");
                }
            }
        }
        return rootType;
    }

    private static void validateActions(ResourceHelper helper, RootEntityContext<PolicyStatement> context, String rootType, Collection<ActionDescriptor> cmdActions, Collection<ActionDescriptor> queryActions) {
        LinkedList cmdActionList = new LinkedList();
        LinkedList queryActionList = new LinkedList();
        if (!rootType.equals("*")) {
            ServiceModule service = context.getEntityQueryProvider(ServiceModule.class).getRoot(helper.getDomainOwner() + ":" + helper.getDomainContext() + ":" + rootType).get();
            context.getEntityQueryProvider(ServiceModule.class).getChildsByType(service.id(), CommandHandlerEntity.class).forEach(a -> cmdActionList.add(a.getHandlerName()));
            context.getEntityQueryProvider(ServiceModule.class).getChildsByType(service.id(), QueryHandlerEntity.class).forEach(a -> queryActionList.add(a.getHandlerName()));
        }
        for (ActionDescriptor action : cmdActions) {
            switch (action.getActionScope()) {
                case EXACT_NAME: {
                    if (rootType.contains("*")) {
                        throw new PolicyValidationError("action definitions not allowed for wild card resource type");
                    }
                    cmdActionList.stream().filter(s -> s.equalsIgnoreCase(action.getName())).findAny().orElseThrow(() -> new PolicyValidationError("resource command action " + action.getName() + " not found"));
                    break;
                }
            }
        }
        for (ActionDescriptor action : queryActions) {
            switch (action.getActionScope()) {
                case EXACT_NAME: {
                    if (rootType.contains("*")) {
                        throw new PolicyValidationError("action definitions not allowed for wild card resource type");
                    }
                    queryActionList.stream().filter(s -> s.equalsIgnoreCase(action.getName())).findAny().orElseThrow(() -> new PolicyValidationError("resource query action " + action.getName() + " not found"));
                    break;
                }
            }
        }
    }

    public static ResourceDescriptor parse(String resourceDesc) {
        String[] parts = (String[])Arrays.asList(resourceDesc.split("/")).stream().map(s -> s.trim()).toArray(String[]::new);
        if (parts[0].equalsIgnoreCase("tenant")) {
            return PolicyStatementParser.parseTenantResource(parts, resourceDesc);
        }
        return PolicyStatementParser.parseNonTenantResource(parts, resourceDesc);
    }

    public static ActionDescriptor parseAction(String action) {
        if ((action = action.trim()).equals("*")) {
            return new ActionDescriptor(action, ActionDescriptor.ActionScope.ALL);
        }
        if (action.endsWith("*")) {
            String prefix = action.substring(0, action.lastIndexOf("*"));
            PolicyStatementParser.validateResourceName(prefix, "Action");
            return new ActionDescriptor(prefix, ActionDescriptor.ActionScope.PREFIX_MATCH);
        }
        PolicyStatementParser.validateResourceName(action, "Action");
        return new ActionDescriptor(action, ActionDescriptor.ActionScope.EXACT_NAME);
    }

    public static ResourceDescriptor parseTenantResource(String[] parts, String resourceDesc) {
        ResourceDescriptor.ResourceScope resourceScope;
        ResourceDescriptor.TenantScope tenantScope;
        PolicyStatementParser.checkMinCount(3, parts.length, "invalid tenant resource pattern. {0}", resourceDesc);
        PolicyStatementParser.checkWord("tenant", parts[0], "invalid keyword. 'tenant' keyword expected", new Object[0]);
        if (parts[1].equals("*")) {
            tenantScope = ResourceDescriptor.TenantScope.ALL;
        } else {
            PolicyStatementParser.validateResourceId(parts[1], "tenantId");
            tenantScope = ResourceDescriptor.TenantScope.TENANT_ID;
        }
        ResourceDescriptor.Builder builder = ResourceDescriptor.builder();
        builder.withTenantId(parts[1]).withTenantScope(tenantScope);
        if (parts[2].equals("**")) {
            PolicyStatementParser.checkCount(3, parts.length, "invalid tenant resource pattern. {0}", resourceDesc);
            return builder.withResourceScope(ResourceDescriptor.ResourceScope.GLOBAL).withVersion(parts[2]).build();
        }
        PolicyStatementParser.validateResourceName(parts[2], "version");
        builder.withVersion(parts[2]);
        if (parts[3].equals("**")) {
            PolicyStatementParser.checkCount(4, parts.length, "invalid tenant resource pattern. {0}", resourceDesc);
            return builder.withResourceScope(ResourceDescriptor.ResourceScope.VERSION_ONLY).withRootType(parts[3]).build();
        }
        PolicyStatementParser.validateResourceName(parts[3], "RootEntity");
        builder.withRootType(parts[3]);
        if (parts[4].equals("*")) {
            resourceScope = ResourceDescriptor.ResourceScope.ALL_ROOT_ID_ONLY;
        } else if (parts[4].equals("**")) {
            resourceScope = ResourceDescriptor.ResourceScope.ALL;
        } else {
            resourceScope = ResourceDescriptor.ResourceScope.ROOT_ID_ONLY;
            PolicyStatementParser.validateResourceId(parts[4], "RootId");
        }
        builder.withRootId(parts[4]).withResourceScope(resourceScope);
        if (parts.length == 5) {
            return builder.build();
        }
        if (resourceScope == ResourceDescriptor.ResourceScope.ALL) {
            throw new PolicyStatementException("invalid tenant resource pattern. {0}", resourceDesc);
        }
        PolicyStatementParser.checkCount(7, parts.length, "invalid tenant resource pattern. {0}", resourceDesc);
        PolicyStatementParser.validateResourceName(parts[5], "ChildType");
        builder.withChildType(parts[5]);
        if (parts[6].equals("*")) {
            resourceScope = parts[4].equals("*") ? ResourceDescriptor.ResourceScope.ALL_ROOT_ID_CHILD_TYPE_ONLY : ResourceDescriptor.ResourceScope.ROOT_ID_CHILD_TYPE_ONLY;
        } else {
            PolicyStatementParser.validateResourceId(parts[6], "ChildId");
            resourceScope = parts[4].equals("*") ? ResourceDescriptor.ResourceScope.ALL_ROOT_ID_CHILD_ID_ONLY : ResourceDescriptor.ResourceScope.ROOT_ID_CHILD_ID_ONLY;
        }
        builder.withChildId(parts[6]);
        builder.withResourceScope(resourceScope);
        return builder.build();
    }

    public static ResourceDescriptor parseNonTenantResource(String[] parts, String resourceDesc) {
        ResourceDescriptor.Builder builder = ResourceDescriptor.builder();
        builder.withTenantScope(ResourceDescriptor.TenantScope.NONE);
        ResourceDescriptor.ResourceScope resourceScope = ResourceDescriptor.ResourceScope.NONE;
        PolicyStatementParser.checkMinCount(1, parts.length, "invalid resource pattern. {0}", resourceDesc);
        if (parts[0].equals("*")) {
            resourceScope = ResourceDescriptor.ResourceScope.GLOBAL;
            PolicyStatementParser.checkCount(1, parts.length, "invalid  resource pattern. {0}", resourceDesc);
            return builder.withVersion(parts[0]).withRootType("*").withResourceScope(resourceScope).build();
        }
        PolicyStatementParser.checkMinCount(2, parts.length, "invalid resource pattern. {0}", resourceDesc);
        PolicyStatementParser.validateResourceName(parts[0], "version");
        if (parts[1].equals("**")) {
            PolicyStatementParser.checkCount(2, parts.length, "invalid resource pattern. {0}", resourceDesc);
            return builder.withVersion(parts[0]).withRootType("*").withResourceScope(ResourceDescriptor.ResourceScope.VERSION_ONLY).build();
        }
        PolicyStatementParser.checkMinCount(3, parts.length, "invalid resource pattern. {0}", resourceDesc);
        PolicyStatementParser.validateResourceName(parts[1], "RootEntity");
        builder.withVersion(parts[0]);
        builder.withRootType(parts[1]);
        if (parts[2].equals("*")) {
            resourceScope = ResourceDescriptor.ResourceScope.ALL_ROOT_ID_ONLY;
        } else if (parts[2].equals("**")) {
            resourceScope = ResourceDescriptor.ResourceScope.ALL;
        } else {
            resourceScope = ResourceDescriptor.ResourceScope.ROOT_ID_ONLY;
            PolicyStatementParser.validateResourceId(parts[2], "RootId");
        }
        builder.withResourceScope(resourceScope);
        builder.withRootId(parts[2]);
        if (parts.length == 3) {
            return builder.build();
        }
        if (resourceScope == ResourceDescriptor.ResourceScope.ALL) {
            throw new PolicyStatementException("invalid resource pattern. {0}", resourceDesc);
        }
        PolicyStatementParser.checkCount(5, parts.length, "invalid non-tenant resource pattern. {0}", resourceDesc);
        PolicyStatementParser.validateResourceName(parts[3], "ChildType");
        builder.withChildType(parts[3]);
        if (parts[4].equals("*")) {
            resourceScope = parts[2].equals("*") ? ResourceDescriptor.ResourceScope.ALL_ROOT_ID_CHILD_TYPE_ONLY : ResourceDescriptor.ResourceScope.ROOT_ID_CHILD_TYPE_ONLY;
        } else {
            PolicyStatementParser.validateResourceId(parts[4], "ChildId");
            resourceScope = parts[4].equals("*") ? ResourceDescriptor.ResourceScope.ALL_ROOT_ID_CHILD_ID_ONLY : ResourceDescriptor.ResourceScope.ROOT_ID_CHILD_ID_ONLY;
        }
        builder.withChildId(parts[4]);
        builder.withResourceScope(resourceScope);
        return builder.build();
    }

    private static void validateResourceName(String resource, String section) {
        Objects.requireNonNull(resource);
        if (!RESOURCE_NAME_PATTERN.matcher(resource).matches()) {
            throw new PolicyStatementException("invalid characters in the {0} : {1}", section, resource);
        }
    }

    private static void validateResourceId(String resource, String section) {
        Objects.requireNonNull(resource);
    }

    private static void checkMinCount(int count, int given, String format, Object ... args) {
        if (count > given) {
            throw new PolicyStatementException(format, args);
        }
    }

    private static void checkCount(int count, int given, String format, Object ... args) {
        if (count != given) {
            throw new PolicyStatementException(format, args);
        }
    }

    private static void checkWord(String word, String given, String format, Object ... args) {
        if (!word.equalsIgnoreCase(given)) {
            throw new PolicyStatementException(format, args);
        }
    }

    public static void main(String[] args) {
        ResourceDescriptor desc = PolicyStatementParser.parse("tenant/id-1234/v_1/Organization/id_2142423");
        System.out.println(desc);
        desc = PolicyStatementParser.parse("tenant/id_1234/v_1/Organization/*");
        System.out.println(desc);
        desc = PolicyStatementParser.parse("tenant/id_1234/v_1/Organization/**");
        System.out.println(desc);
        desc = PolicyStatementParser.parse("tenant/id_1234/v_1/Organization/*/Tenant/*");
        System.out.println(desc);
        desc = PolicyStatementParser.parse("tenant/id-1234/v_1/Organization/*/Tenant/id_3522");
        System.out.println(desc);
        desc = PolicyStatementParser.parse("tenant/id_1234/v_1/Organization/id_6764374/Tenant/id_3522");
        System.out.println(desc);
        desc = PolicyStatementParser.parse("tenant/{token.id}/v_1/Organization/id_6764374/Tenant/id_3522");
        System.out.println(desc);
        desc = PolicyStatementParser.parse("tenant/{token.id}/**");
        System.out.println(desc);
        desc = PolicyStatementParser.parse("tenant/{token.id}/v1/**");
        System.out.println(desc);
        System.out.println("------------------------------------");
        desc = PolicyStatementParser.parse("v_1/Organization/id_2142423");
        System.out.println(desc);
        desc = PolicyStatementParser.parse("v_1/Organization/*");
        System.out.println(desc);
        desc = PolicyStatementParser.parse("v_1/Organization/**");
        System.out.println(desc);
        desc = PolicyStatementParser.parse("v_1/Organization/*/Tenant/*");
        System.out.println(desc);
        desc = PolicyStatementParser.parse("v_1/Organization/*/Tenant/id_3522");
        System.out.println(desc);
        desc = PolicyStatementParser.parse("v_1/Organization/id_6764374/Tenant/id_3522");
        System.out.println(desc);
    }
}

