/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.runtime.repo;

import com.cloudimpl.outstack.runtime.ResultSet;
import com.cloudimpl.outstack.runtime.common.GsonCodecRuntime;
import com.cloudimpl.outstack.runtime.domainspec.Query;
import com.cloudimpl.outstack.runtime.repo.RepositoryException;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class EventRepoUtil {
    public static <T> boolean onFilter(T item, Map<String, String> params) {
        return EventRepoUtil.onFilter(item, params, null);
    }

    public static <T> T injectField(Class<T> type, T obj, String fieldName, String value) {
        JsonObject json = GsonCodecRuntime.encodeToJson(obj).getAsJsonObject();
        json.addProperty(fieldName, value);
        return GsonCodecRuntime.decode(type, json.toString());
    }

    public static <T> boolean onFilter(T item, Map<String, String> params, Consumer<JsonObject> injector) {
        if (params.isEmpty()) {
            return true;
        }
        JsonObject json = GsonCodecRuntime.encodeToJson(item).getAsJsonObject();
        if (injector != null) {
            injector.accept(json);
        }
        for (Map.Entry<String, String> entry : params.entrySet()) {
            JsonElement el = json.get(entry.getKey());
            if (el == null || !el.isJsonPrimitive()) {
                System.out.println("el " + entry.getKey() + " not found or not an primitive data type");
                return false;
            }
            JsonPrimitive jsonPrim = (JsonPrimitive)el;
            if (jsonPrim.isNumber()) {
                BigDecimal target = new BigDecimal(entry.getValue());
                if (jsonPrim.getAsBigDecimal().compareTo(target) == 0) continue;
                return false;
            }
            if (jsonPrim.isString()) {
                if (entry.getValue().startsWith("%") && entry.getValue().length() > 1) {
                    if (jsonPrim.getAsString().toLowerCase().endsWith(entry.getValue().substring(1).toLowerCase())) continue;
                    return false;
                }
                if (entry.getValue().endsWith("%") && entry.getValue().length() > 1) {
                    if (jsonPrim.getAsString().toLowerCase().startsWith(entry.getValue().substring(0, entry.getValue().length() - 1).toLowerCase())) continue;
                    return false;
                }
                if (entry.getValue().contains("*")) {
                    String queryStr = entry.getValue();
                    queryStr = queryStr.replaceAll("\\*", "\\\\w*");
                    if (jsonPrim.getAsString().matches("(?i).*" + queryStr + ".*")) continue;
                    return false;
                }
                if (jsonPrim.getAsString().equalsIgnoreCase(entry.getValue())) continue;
                return false;
            }
            if (jsonPrim.isBoolean()) {
                if (jsonPrim.getAsBoolean() == Boolean.valueOf(entry.getValue()).booleanValue()) continue;
                return false;
            }
            System.out.println("unhandle primitive data type:" + jsonPrim);
            return false;
        }
        return true;
    }

    public static int compare(String name, Object left, Object right) {
        JsonObject leftJson = GsonCodecRuntime.encodeToJson(left).getAsJsonObject();
        JsonObject rightJson = GsonCodecRuntime.encodeToJson(right).getAsJsonObject();
        JsonElement leftEl = leftJson.get(name);
        JsonElement rightEl = rightJson.get(name);
        if (leftEl == null && rightEl == null) {
            return 0;
        }
        if (leftEl == null && rightEl != null) {
            return 1;
        }
        if (leftEl != null && rightEl == null) {
            return -1;
        }
        if (!leftEl.isJsonPrimitive() || !rightEl.isJsonPrimitive()) {
            throw new RepositoryException("only primitive types supported for sorting", new Object[0]);
        }
        JsonPrimitive leftPrim = leftEl.getAsJsonPrimitive();
        JsonPrimitive rightPrim = rightEl.getAsJsonPrimitive();
        if (leftPrim.isNumber() && rightPrim.isNumber()) {
            return leftPrim.getAsBigDecimal().compareTo(rightPrim.getAsBigDecimal());
        }
        if (leftPrim.isString() && rightPrim.isString()) {
            return leftPrim.getAsString().compareToIgnoreCase(rightPrim.getAsString());
        }
        if (leftPrim.isBoolean() && rightPrim.isBoolean()) {
            return Boolean.compare(leftPrim.getAsBoolean(), rightPrim.getAsBoolean());
        }
        throw new RepositoryException("unsupported data type for sorting . {0} : {1} ", leftJson, rightJson);
    }

    public static <T> ResultSet<T> onPageable(Collection<T> result, Query.PagingRequest paging) {
        if (paging == null) {
            return new ResultSet<T>(result.size(), 1, 0, result);
        }
        Comparator comparator = null;
        for (Query.Order order : paging.orders()) {
            Comparator comp = (left, right) -> EventRepoUtil.compare(order.getName(), left, right);
            if (order.getDirection() == Query.Direction.DESC) {
                comp = comp.reversed();
            }
            comparator = comparator == null ? comp : comparator.thenComparing(comp);
        }
        int offset = paging.pageNum() * paging.pageSize();
        int min = Math.min(result.size() - offset, paging.pageSize());
        Collection out = comparator != null ? (Collection)result.stream().sorted(comparator).skip(offset).limit(min).collect(Collectors.toList()) : (Collection)result.stream().skip(offset).limit(min < 0 ? 0L : (long)min).collect(Collectors.toList());
        return new ResultSet(result.size(), (int)Math.ceil((double)result.size() / (double)paging.pageSize()), paging.pageNum(), out);
    }
}

