/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.runtime.repo;

import com.cloudimpl.outstack.runtime.EntityCheckpoint;
import com.cloudimpl.outstack.runtime.EntityIdHelper;
import com.cloudimpl.outstack.runtime.EventRepositoy;
import com.cloudimpl.outstack.runtime.ResourceHelper;
import com.cloudimpl.outstack.runtime.ResultSet;
import com.cloudimpl.outstack.runtime.domainspec.ChildEntity;
import com.cloudimpl.outstack.runtime.domainspec.Entity;
import com.cloudimpl.outstack.runtime.domainspec.Event;
import com.cloudimpl.outstack.runtime.domainspec.Query;
import com.cloudimpl.outstack.runtime.domainspec.RootEntity;
import com.cloudimpl.outstack.runtime.domainspec.TenantRequirement;
import com.cloudimpl.outstack.runtime.repo.EventRepoUtil;
import com.cloudimpl.outstack.runtime.repo.RepositoryException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class MemEventRepository<T extends RootEntity>
extends EventRepositoy<T> {
    private final TreeMap<String, Entity> mapEntites = new TreeMap();
    private final List<Event> events = new CopyOnWriteArrayList<Event>();
    private final Map<String, EntityCheckpoint> checkpoints = new HashMap<String, EntityCheckpoint>();

    public MemEventRepository(Class<T> rootType, ResourceHelper resourceHelper) {
        super(rootType, resourceHelper);
        System.out.println("MemEventRepository : " + rootType.getName() + "initialized");
    }

    @Override
    protected void startTransaction() {
    }

    @Override
    protected void endTransaction() {
    }

    protected void saveEntity(Entity e) {
        this.mapEntites.put(this.resourceHelper.getFQTrn(e), e);
        this.mapEntites.put(this.resourceHelper.getFQBrn(e), e);
    }

    protected <C extends ChildEntity<T>> Collection<C> getAllChildByType(String rootBrn, Class<T> rootType, String id, Class<C> childType) {
        return this.mapEntites.entrySet().stream().filter(e -> ((Entity)e.getValue()).getClass() == childType).filter(e -> ((String)e.getKey()).startsWith(rootBrn)).map(e -> (Entity)e.getValue()).map(c -> (ChildEntity)c).collect(Collectors.toList());
    }

    @Override
    protected Optional<EntityCheckpoint> _getCheckpoint(String rootTrn) {
        return Optional.of(this.checkpoints.computeIfAbsent(rootTrn, trn -> new EntityCheckpoint((String)trn)));
    }

    @Override
    public synchronized <K extends ChildEntity<T>> ResultSet<K> getAllChildByType(Class<T> rootType, String id, Class<K> childType, String tenantId, Query.PagingRequest paging) {
        EntityIdHelper.validateTechnicalId(id);
        String trn = null;
        TenantRequirement tenantReq = Entity.checkTenantRequirement(rootType);
        switch (tenantReq) {
            case REQUIRED: {
                trn = this.resourcePrefix("brn") + ":tenant/" + tenantId + "/" + this.version + "/" + rootType.getSimpleName() + "/" + id;
                break;
            }
            case OPTIONAL: {
                if (tenantId != null) {
                    trn = this.resourcePrefix("brn") + ":tenant/" + tenantId + "/" + this.version + "/" + rootType.getSimpleName() + "/" + id;
                    break;
                }
                trn = this.resourcePrefix("brn") + ":" + this.version + "/" + rootType.getSimpleName() + "/" + id;
                break;
            }
            default: {
                trn = this.resourcePrefix("brn") + ":" + this.version + "/" + rootType.getSimpleName() + "/" + id;
            }
        }
        String fqtrn = trn;
        Collection result = this.getAllChildByType(trn, rootType, id, childType).stream().filter(e -> EventRepoUtil.onFilter(e, paging.getParams())).collect(Collectors.toList());
        ResultSet col = EventRepoUtil.onPageable(result, paging);
        return col;
    }

    @Override
    public <T1 extends ChildEntity<T>> ResultSet<T1> getAllChildByType(Class<T> rootType, String id, Class<T1> childType, Collection<String> tenantId, Query.PagingRequest paging) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public synchronized Optional<T> getRootById(Class<T> rootType, String id, String tenantId) {
        if (id.startsWith("id-")) {
            return Optional.ofNullable((RootEntity)this.mapEntites.get(this.resourceHelper.getFQTrn(RootEntity.makeTRN(rootType, this.version, id, tenantId))));
        }
        return Optional.ofNullable((RootEntity)this.mapEntites.get(this.resourceHelper.getFQBrn(RootEntity.makeRN(rootType, this.version, id, tenantId))));
    }

    @Override
    public synchronized <C extends ChildEntity<T>> Optional<C> getChildById(Class<T> rootType, String id, Class<C> childType, String childId, String tenantId) {
        EntityIdHelper.validateTechnicalId(id);
        if (childId.startsWith("id-")) {
            return Optional.ofNullable((ChildEntity)this.mapEntites.get(this.resourceHelper.getFQTrn(ChildEntity.makeTRN(rootType, this.version, id, childType, childId, tenantId))));
        }
        return Optional.ofNullable((ChildEntity)this.mapEntites.get(this.resourceHelper.getFQBrn(ChildEntity.makeRN(rootType, this.version, id, childType, childId, tenantId))));
    }

    @Override
    public synchronized ResultSet<T> getAllByRootType(Class<T> rootType, String tenantId, Query.PagingRequest paging) {
        String trn = null;
        TenantRequirement tenantReq = Entity.checkTenantRequirement(rootType);
        switch (tenantReq) {
            case REQUIRED: {
                trn = this.resourcePrefix("brn") + ":tenant/" + tenantId + "/" + this.version + "/" + rootType.getSimpleName() + "/";
                break;
            }
            case OPTIONAL: {
                if (tenantId != null) {
                    trn = this.resourcePrefix("brn") + ":tenant/" + tenantId + "/" + this.version + "/" + rootType.getSimpleName() + "/";
                    break;
                }
                trn = this.resourcePrefix("brn") + ":" + this.version + "/" + rootType.getSimpleName() + "/";
                break;
            }
            default: {
                trn = this.resourcePrefix("brn") + ":" + this.version + "/" + rootType.getSimpleName() + "/";
            }
        }
        String fqtrn = trn;
        Collection filterCollection = this.mapEntites.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(fqtrn)).filter(e -> ((Entity)e.getValue()).getClass() == rootType).map(e -> (RootEntity)e.getValue()).filter(e -> EventRepoUtil.onFilter(e, paging.getParams())).collect(Collectors.toList());
        return EventRepoUtil.onPageable(filterCollection, paging);
    }

    @Override
    public ResultSet<T> getAllByRootType(Class<T> rootType, Collection<String> tenantId, Query.PagingRequest paging) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public <K> K executeRawQuery(String rawQuery) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public ResultSet<Event<T>> getEventsByRootId(Class<T> rootType, String rootId, String tenantId, Query.PagingRequest paging) {
        String rn;
        boolean technicalId = false;
        if (rootId.startsWith("id-")) {
            rn = RootEntity.makeTRN(rootType, this.version, rootId, tenantId);
            technicalId = true;
        } else {
            rn = RootEntity.makeRN(rootType, this.version, rootId, tenantId);
        }
        String rootTrn = RootEntity.makeTRN(rootType, this.version, rootId, tenantId);
        int size = this.events.size();
        Stream<Event> stream = IntStream.range(0, size).mapToObj(i -> this.events.get(size - i - 1));
        stream = technicalId ? stream.filter(e -> e.getEntityTRN().equals(rn)) : stream.filter(e -> e.getEntityRN().equals(rn));
        Collection cols = stream.map(e -> e).filter(e -> EventRepoUtil.onFilter(e, paging.getParams())).collect(Collectors.toList());
        return EventRepoUtil.onPageable(cols, paging);
    }

    @Override
    public <K extends ChildEntity<T>> ResultSet<Event<K>> getEventsByChildId(Class<T> rootType, String id, Class<K> childType, String childId, String tenantId, Query.PagingRequest paging) {
        String rn;
        EntityIdHelper.validateTechnicalId(id);
        boolean technicald = false;
        if (childId.startsWith("id-")) {
            rn = ChildEntity.makeTRN(rootType, this.version, id, childType, childId, tenantId);
            technicald = true;
        } else {
            rn = ChildEntity.makeRN(rootType, this.version, id, childType, childId, tenantId);
        }
        int size = this.events.size();
        Stream<Event> stream = IntStream.range(0, size).mapToObj(i -> this.events.get(size - i - 1));
        stream = technicald ? stream.filter(e -> e.getEntityTRN().equals(rn)) : stream.filter(e -> e.getEntityRN().equals(rn));
        Collection cols = stream.map(e -> e).filter(e -> EventRepoUtil.onFilter(e, paging.getParams())).collect(Collectors.toList());
        return EventRepoUtil.onPageable(cols, paging);
    }

    @Override
    protected void saveRootEntityBrnIfNotExist(RootEntity e) {
        Entity old = this.mapEntites.putIfAbsent(this.resourceHelper.getFQBrn(e), e);
        if (old != null) {
            throw new RepositoryException("{0} exist.", e.getBRN());
        }
    }

    @Override
    protected void saveRootEntityTrnIfNotExist(RootEntity e) {
        Entity old = this.mapEntites.putIfAbsent(this.resourceHelper.getFQTrn(e), e);
        if (old != null) {
            throw new RepositoryException("{0} exist.", e.getTRN());
        }
    }

    @Override
    protected void saveRootEntityBrnIfExist(long lastSeq, RootEntity e) {
        this.mapEntites.put(this.resourceHelper.getFQBrn(e), e);
    }

    @Override
    protected void saveRootEntityTrnIfExist(long lastSeq, RootEntity e) {
        this.mapEntites.put(this.resourceHelper.getFQTrn(e), e);
    }

    @Override
    protected void saveChildEntityBrnIfNotExist(ChildEntity e) {
        Entity old = this.mapEntites.putIfAbsent(this.resourceHelper.getFQBrn(e), e);
        if (old != null) {
            throw new RepositoryException("{0} exist.", e.getBRN());
        }
    }

    @Override
    protected void saveChildEntityTrnIfNotExist(ChildEntity e) {
        Entity old = this.mapEntites.putIfAbsent(this.resourceHelper.getFQTrn(e), e);
        if (old != null) {
            throw new RepositoryException("{0} exist.", e.getTRN());
        }
    }

    @Override
    protected void saveChildEntityBrnIfExist(long lastSeq, ChildEntity e) {
        this.mapEntites.put(this.resourceHelper.getFQBrn(e), e);
    }

    @Override
    protected void saveChildEntityTrnIfExist(long lastSeq, ChildEntity e) {
        this.mapEntites.put(this.resourceHelper.getFQTrn(e), e);
    }

    @Override
    protected void deleteRootEntityBrnById(RootEntity e, boolean deleteOnlyEntity) {
        EntityIdHelper.validateEntityId(e.entityId());
        String brn = this.resourceHelper.getFQBrn(RootEntity.makeRN(this.rootType, this.version, e.entityId(), e.getTenantId()));
        this.mapEntites.remove(brn);
    }

    @Override
    protected void deleteRootEntityTrnById(Class<T> rootType, String id, String tenantId) {
        EntityIdHelper.validateTechnicalId(id);
        String trn = this.resourceHelper.getFQTrn(RootEntity.makeTRN(rootType, this.version, id, tenantId));
        this.mapEntites.remove(trn);
    }

    @Override
    protected <C extends ChildEntity<T>> void deleteChildEntityBrnById(ChildEntity e, boolean deleteOnlyEntity) {
        String brn = this.resourceHelper.getFQBrn(ChildEntity.makeRN(this.rootType, this.version, e.rootId(), e.getClass(), e.id(), e.getTenantId()));
        this.mapEntites.remove(brn);
    }

    @Override
    protected <C extends ChildEntity<T>> void deleteChildEntityTrnById(Class<T> rootType, String id, Class<C> childType, String childId, String tenantId) {
        EntityIdHelper.validateTechnicalId(id);
        EntityIdHelper.validateTechnicalId(childId);
        String brn = this.resourceHelper.getFQTrn(ChildEntity.makeTRN(rootType, this.version, id, childType, childId, tenantId));
        this.mapEntites.remove(brn);
    }

    @Override
    protected void addEvent(Event event) {
        this.events.add(event);
    }

    @Override
    protected void updateCheckpoint(EntityCheckpoint checkpoint) {
        this.checkpoints.put(checkpoint.getRootTrn(), checkpoint);
    }

    @Override
    public boolean isIdExist(String id, String tenantId) {
        EntityIdHelper.validateTechnicalId(id);
        return this.mapEntites.values().stream().filter(e -> tenantId == null ? e.getTenantId() == null : e.getTenantId().equals(tenantId)).filter(e -> e.id().equals(id)).findAny().isPresent();
    }
}

