/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.runtime.repo;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class RepoStreamingReq {
    private final Map<String, List<ResourceInfo>> mapResources;
    private final List<ResourceInfo> initialDownload;

    public RepoStreamingReq(List<ResourceInfo> initialDownload, List<ResourceInfo> resourceList) {
        this.mapResources = resourceList.stream().collect(Collectors.groupingBy(r -> r.getEntityType(), Collectors.toList()));
        this.initialDownload = new LinkedList<ResourceInfo>(initialDownload);
    }

    public Optional<List<ResourceInfo>> getResources(String entityType) {
        return Optional.ofNullable(this.mapResources.get(entityType));
    }

    public List<ResourceInfo> getInitialDownloadResources() {
        return this.initialDownload;
    }

    public static final class ResourceInfo {
        private final String entityType;
        private final String entityId;
        private final String tenantId;
        private final String childType;
        private final String childId;
        private final String searchParam;

        public ResourceInfo(String entityType, String entityId, String tenantId) {
            this(entityType, entityId, null, null, tenantId);
        }

        public ResourceInfo(String entityType, String entityId, String tenantId, String searchParam) {
            this(entityType, entityId, null, null, tenantId, searchParam);
        }

        public ResourceInfo(String entityType, String entityId, String childType, String childId, String tenantId) {
            this(entityType, entityId, childType, childId, tenantId, null);
        }

        public ResourceInfo(String entityType, String entityId, String childType, String childId, String tenantId, String searchParam) {
            this.entityType = entityType;
            this.entityId = entityId;
            this.childType = childType;
            this.childId = childId;
            this.tenantId = tenantId;
            this.searchParam = searchParam;
        }

        public String getEntityId() {
            return this.entityId;
        }

        public String getSearchParam() {
            return this.searchParam;
        }

        public String getEntityType() {
            return this.entityType;
        }

        public String getTenantId() {
            return this.tenantId;
        }

        public String getChildType() {
            return this.childType;
        }

        public String getChildId() {
            return this.childId;
        }
    }
}

