/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.runtime.util;

import com.cloudimpl.outstack.collection.error.CollectionException;
import com.cloudimpl.outstack.runtime.ReflectionException;
import com.cloudimpl.outstack.runtime.domainspec.Entity;
import com.cloudimpl.outstack.runtime.domainspec.Id;
import com.cloudimpl.outstack.runtime.domainspec.IgnoreCase;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.function.Function;
import reactor.util.retry.Retry;

public class Util {
    public static <T> T createObject(Class<T> type, VarArg<Class<?>> types, VarArg<Object> args) {
        try {
            return type.getConstructor(types.getArgs()).newInstance(args.getArgs());
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new ReflectionException(ex);
        }
    }

    public static boolean isIdFieldIgnoreCase(Class<? extends Entity> entity) {
        Field f = Util.getIdField(entity);
        return f.isAnnotationPresent(IgnoreCase.class);
    }

    public static Field getIdField(Class<? extends Entity> type) {
        return Arrays.asList(type.getDeclaredFields()).stream().filter(e -> e.isAnnotationPresent(Id.class)).findFirst().orElseThrow(() -> new RuntimeException("Id Field not found in :" + type));
    }

    public static Retry wrap(reactor.retry.Retry retry) {
        return Retry.withThrowable((Function)retry);
    }

    public static <T> Class<T> classForName(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException ex) {
            throw new ReflectionException(ex);
        }
    }

    public static <T> Class<T> extractGenericParameter(Class<?> parameterizedSubClass, Class<?> genericSuperClass, int pos) {
        HashMap mapping = new HashMap();
        Class klass = parameterizedSubClass;
        while (klass != null) {
            Type superType = klass.getGenericSuperclass();
            Type[] genericInterfaces = klass.getGenericInterfaces();
            for (int j = 0; j <= genericInterfaces.length; ++j) {
                Type type;
                Type type2 = type = j == 0 ? superType : genericInterfaces[j - 1];
                if (type instanceof ParameterizedType) {
                    ParameterizedType parType = (ParameterizedType)type;
                    Type rawType = parType.getRawType();
                    if (rawType.equals(genericSuperClass)) {
                        Type t = parType.getActualTypeArguments()[pos];
                        if (t instanceof Class) {
                            return (Class)t;
                        }
                        return (Class)mapping.get((TypeVariable)t);
                    }
                    TypeVariable<?>[] vars = ((GenericDeclaration)((Object)parType.getRawType())).getTypeParameters();
                    Type[] args = parType.getActualTypeArguments();
                    for (int i = 0; i < vars.length; ++i) {
                        if (args[i] instanceof Class) {
                            mapping.put(vars[i], (Class)args[i]);
                            continue;
                        }
                        mapping.put(vars[i], (Class)mapping.get((TypeVariable)args[i]));
                    }
                    klass = (Class)rawType;
                    continue;
                }
                klass = klass.getSuperclass();
            }
        }
        throw CollectionException.RELECTION_EXCEPTION(err -> err.wrap(new RuntimeException("template parameter not found")));
    }

    public static final class VarArg<T> {
        private final T[] args;

        public VarArg(T ... args) {
            this.args = args;
        }

        public T[] getArgs() {
            return this.args;
        }
    }
}

