/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.runtime;

import com.cloudimpl.outstack.runtime.EntityCommandHandler;
import com.cloudimpl.outstack.runtime.EntityContext;
import com.cloudimpl.outstack.runtime.EntityContextProvider;
import com.cloudimpl.outstack.runtime.InputMetaProvider;
import com.cloudimpl.outstack.runtime.domainspec.Command;
import com.cloudimpl.outstack.runtime.domainspec.DomainEventException;
import com.cloudimpl.outstack.runtime.domainspec.ICommand;
import com.cloudimpl.outstack.runtime.domainspec.RootEntity;
import com.cloudimpl.outstack.runtime.domainspec.TenantRequirement;
import reactor.core.publisher.Mono;

public abstract class AsyncEntityCommandHandler<T extends RootEntity, C extends Command, R>
extends EntityCommandHandler<T, C, Mono<R>> {
    public Mono<EntityContext<T>> emitAsync(EntityContextProvider contextProvider, ICommand input) {
        if (input.version() != null && !contextProvider.getVersion().equals(input.version())) {
            throw new DomainEventException(DomainEventException.ErrorCode.INVALID_VERSION, "invalid version {0} ,expecting {1}", input.version(), contextProvider.getVersion());
        }
        Object cmd = input.unwrap(this.cmdType);
        this.validateInput(cmd);
        EntityContextProvider.Transaction tx = contextProvider.createWritableTransaction(((Command)cmd).rootId(), this.getTenantRequirement() == TenantRequirement.NONE ? null : ((Command)cmd).tenantId(), true);
        tx.setInputMetaProvider(new InputMetaProvider(){
            final /* synthetic */ Command val$cmd;
            {
                this.val$cmd = command;
            }

            @Override
            public String getUserName() {
                return this.val$cmd.getMapAttr().get("userName");
            }

            @Override
            public String getUserId() {
                return this.val$cmd.getMapAttr().get("userId");
            }
        });
        EntityContext context = (EntityContext)tx.getContext(this.entityType);
        context.setTx(tx);
        return ((Mono)this.apply(context, cmd)).doOnNext(r -> tx.setReply(r)).map(r -> context);
    }
}

