/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.runtime;

import com.cloudimpl.outstack.runtime.AsyncEntityContext;
import com.cloudimpl.outstack.runtime.AsyncRootEntityQueryContext;
import com.cloudimpl.outstack.runtime.CRUDOperations;
import com.cloudimpl.outstack.runtime.ChildEntityQueryContext;
import com.cloudimpl.outstack.runtime.EntityContext;
import com.cloudimpl.outstack.runtime.EntityIdHelper;
import com.cloudimpl.outstack.runtime.EntityProvider;
import com.cloudimpl.outstack.runtime.QueryOperations;
import com.cloudimpl.outstack.runtime.ResultSet;
import com.cloudimpl.outstack.runtime.RootEntityContext;
import com.cloudimpl.outstack.runtime.RootEntityQueryContext;
import com.cloudimpl.outstack.runtime.domainspec.ChildEntity;
import com.cloudimpl.outstack.runtime.domainspec.DomainEventException;
import com.cloudimpl.outstack.runtime.domainspec.Entity;
import com.cloudimpl.outstack.runtime.domainspec.EntityDeleted;
import com.cloudimpl.outstack.runtime.domainspec.EntityHelper;
import com.cloudimpl.outstack.runtime.domainspec.EntityRenamed;
import com.cloudimpl.outstack.runtime.domainspec.Event;
import com.cloudimpl.outstack.runtime.domainspec.Query;
import com.cloudimpl.outstack.runtime.domainspec.RootEntity;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class ChildEntityContext<R extends RootEntity, T extends ChildEntity<R>>
extends EntityContext<T>
implements ChildEntityQueryContext<R, T> {
    private final Class<R> rootType;
    private final String rootId;

    public ChildEntityContext(Class<R> rootType, String rootId, Class<T> entityType, String tenantId, Optional<EntityProvider<? extends RootEntity>> entitySupplier, Supplier<String> idGenerator, Optional<CRUDOperations> crudOperations, QueryOperations<R> queryOperation, Optional<Consumer<Event>> eventPublisher, Consumer<Object> validator, Function<Class<? extends RootEntity>, QueryOperations<?>> queryOperationSelector, String version) {
        super(entityType, tenantId, entitySupplier, idGenerator, crudOperations, queryOperation, eventPublisher, validator, queryOperationSelector, version);
        this.rootType = rootType;
        this.rootId = rootId;
        Objects.requireNonNull(this.rootId);
    }

    @Override
    public T create(String id, Event<T> event) {
        EntityIdHelper.validateEntityId(id);
        EntityIdHelper.validateTechnicalId(this.rootId);
        EntityHelper.validateEvent(this.rootType, event);
        this.validator.accept(event);
        RootEntity root = (RootEntity)this.getEntityProvider().loadEntity(this.rootType, this.rootId, null, null, this.getTenantId()).orElseThrow(() -> new DomainEventException(DomainEventException.ErrorCode.ENTITY_NOT_FOUND, "root entity {0} is not exist", event.getRootEntityRN()));
        this.getEntityProvider().loadEntity(this.rootType, root.id(), this.entityType, id, this.getTenantId()).ifPresent(e -> {
            throw new DomainEventException(DomainEventException.ErrorCode.ENTITY_EXIST, "child entity {0} is already exist", e.getBRN());
        });
        if (!event.entityId().equals(id)) {
            throw new DomainEventException(DomainEventException.ErrorCode.ENTITY_EVENT_RELATION_VIOLATION, "event id and given id not equal. {0} , {1}", id, event.entityId());
        }
        if (!root.entityId().equals(event.rootEntityId())) {
            throw new DomainEventException(DomainEventException.ErrorCode.ENTITY_EVENT_RELATION_VIOLATION, "root entity Id and event root id not equal. {0} , {1}", root.entityId(), event.rootEntityId());
        }
        EntityHelper.setCreatedDate(event, System.currentTimeMillis());
        EntityHelper.setUserId(event, this.getTx().getInputMetaProvider().getUserId());
        EntityHelper.setUserName(event, this.getTx().getInputMetaProvider().getUserName());
        EntityHelper.setVersion(event, this.version);
        Object child = root.createChildEntity(this.entityType, id, (String)this.idGenerator.get());
        event.setTenantId(this.getTenantId());
        event.setRootId(root.id());
        event.setId(((Entity)child).id());
        event.setAction(Event.Action.CREATE);
        EntityHelper.applyEvent(child, event);
        EntityHelper.setCreatedDate(child, event.getMeta().createdDate());
        EntityHelper.setUpdatedDate(child, event.getMeta().createdDate());
        EntityHelper.setUserId(child, this.getTx().getInputMetaProvider().getUserId());
        EntityHelper.setUserName(child, this.getTx().getInputMetaProvider().getUserName());
        this.addEvent(event);
        this.validator.accept(child);
        this.getCrudOperations().create((Entity)child);
        this.getEventPublisher().accept(event);
        return child;
    }

    @Override
    public T update(String id, Event<T> event) {
        EntityIdHelper.validateTechnicalId(this.rootId);
        this.validator.accept(event);
        EntityHelper.validateEvent(this.rootType, event);
        RootEntity root = (RootEntity)this.getEntityProvider().loadEntity(this.rootType, this.rootId, null, null, this.getTenantId()).orElseThrow(() -> new DomainEventException(DomainEventException.ErrorCode.ENTITY_NOT_FOUND, "root entity {0} is not exist", event.getRootEntityRN()));
        ChildEntity child = (ChildEntity)this.getEntityProvider().loadEntity(this.rootType, root.id(), this.entityType, id, this.getTenantId()).orElseThrow(() -> new DomainEventException(DomainEventException.ErrorCode.ENTITY_NOT_FOUND, "child entity {0} is does not exist", ChildEntity.makeRN(this.rootType, this.getVersion(), root.entityId(), this.entityType, id, this.getTenantId())));
        if (!event.rootEntityId().equals(root.entityId())) {
            throw new DomainEventException(DomainEventException.ErrorCode.ENTITY_EVENT_RELATION_VIOLATION, "invalid root entity id {0} in the event faor root entity {1}", event.rootEntityId(), root.entityId());
        }
        EntityIdHelper.validateId(id, child);
        EntityHelper.setCreatedDate(event, System.currentTimeMillis());
        EntityHelper.setUserId(event, this.getTx().getInputMetaProvider().getUserId());
        EntityHelper.setUserName(event, this.getTx().getInputMetaProvider().getUserName());
        EntityHelper.setVersion(event, this.version);
        event.setTenantId(this.getTenantId());
        event.setRootId(root.id());
        event.setId(child.id());
        event.setAction(Event.Action.UPDATE);
        EntityHelper.applyEvent(child, event);
        EntityHelper.setUpdatedDate(child, event.getMeta().createdDate());
        EntityHelper.setUserId(child, this.getTx().getInputMetaProvider().getUserId());
        EntityHelper.setUserName(child, this.getTx().getInputMetaProvider().getUserName());
        this.validator.accept(child);
        EntityIdHelper.validateId(id, event);
        this.addEvent(event);
        this.getCrudOperations().update(child);
        this.getEventPublisher().accept(event);
        return (T)child;
    }

    @Override
    public T delete(String id) {
        EntityIdHelper.validateTechnicalId(this.rootId);
        RootEntity root = (RootEntity)this.getEntityProvider().loadEntity(this.rootType, this.rootId, null, null, this.getTenantId()).orElseThrow(() -> new DomainEventException(DomainEventException.ErrorCode.ENTITY_NOT_FOUND, "root entity {0}:{1} is not exist", this.rootType.getSimpleName(), this.rootId));
        ChildEntity child = (ChildEntity)this.getEntityProvider().loadEntity(this.rootType, root.id(), this.entityType, id, this.getTenantId()).orElseThrow(() -> new DomainEventException(DomainEventException.ErrorCode.ENTITY_NOT_FOUND, "child entity {0} is does not exist", ChildEntity.makeRN(this.rootType, this.getVersion(), root.entityId(), this.entityType, id, this.getTenantId())));
        EntityIdHelper.validateId(id, child);
        EntityDeleted event = new EntityDeleted(this.entityType, this.rootType, child.entityId(), root.entityId());
        event.setTenantId(this.getTenantId());
        event.setRootId(root.id());
        event.setId(child.id());
        EntityHelper.setCreatedDate(event, System.currentTimeMillis());
        EntityHelper.setUserId(event, this.getTx().getInputMetaProvider().getUserId());
        EntityHelper.setUserName(event, this.getTx().getInputMetaProvider().getUserName());
        EntityHelper.setVersion(event, this.version);
        event.setAction(Event.Action.DELETE);
        this.validator.accept(event);
        this.addEvent(event);
        this.getCrudOperations().delete(child);
        this.getEventPublisher().accept(event);
        return (T)child;
    }

    @Override
    public T rename(String id, String newId) {
        EntityIdHelper.validateTechnicalId(this.rootId);
        RootEntity root = (RootEntity)this.getEntityProvider().loadEntity(this.rootType, this.rootId, null, null, this.getTenantId()).orElseThrow(() -> new DomainEventException(DomainEventException.ErrorCode.ENTITY_NOT_FOUND, "root entity {0}:{1} is not exist", this.rootType.getSimpleName(), this.rootId));
        ChildEntity child = (ChildEntity)this.getEntityProvider().loadEntity(this.rootType, root.id(), this.entityType, id, this.getTenantId()).orElseThrow(() -> new DomainEventException(DomainEventException.ErrorCode.ENTITY_NOT_FOUND, "child entity {0} is does not exist", ChildEntity.makeRN(this.rootType, this.getVersion(), root.entityId(), this.entityType, id, this.getTenantId())));
        EntityIdHelper.validateId(id, child);
        EntityRenamed event = new EntityRenamed(this.entityType, this.rootType, newId, id, root.entityId());
        event.setTenantId(this.getTenantId());
        event.setRootId(root.id());
        event.setId(child.id());
        EntityHelper.setCreatedDate(event, System.currentTimeMillis());
        EntityHelper.setUserId(event, this.getTx().getInputMetaProvider().getUserId());
        EntityHelper.setUserName(event, this.getTx().getInputMetaProvider().getUserName());
        EntityHelper.setVersion(event, this.version);
        event.setAction(Event.Action.RENAME);
        this.validator.accept(event);
        this.addEvent(event);
        ChildEntity old = child;
        child = (ChildEntity)child.rename(newId);
        EntityHelper.setUpdatedDate(child, event.getMeta().createdDate());
        EntityHelper.setUserId(child, this.getTx().getInputMetaProvider().getUserId());
        EntityHelper.setUserName(child, this.getTx().getInputMetaProvider().getUserName());
        this.validator.accept(child);
        this.getCrudOperations().rename(old, child);
        this.getEventPublisher().accept(event);
        return (T)child;
    }

    @Override
    public <R extends RootEntity> RootEntityContext<R> asRootContext() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public ChildEntityContext<R, T> asChildContext() {
        return this;
    }

    @Override
    public Optional<T> getEntityById(String id) {
        EntityIdHelper.validateTechnicalId(this.rootId);
        return this.getQueryOperations().getChildById(this.rootType, this.rootId, this.entityType, id, this.getTenantId());
    }

    @Override
    public R getRoot() {
        return (R)((RootEntity)this.getQueryOperations().getRootById(this.rootType, this.rootId, this.getTenantId()).orElseThrow(() -> new DomainEventException(DomainEventException.ErrorCode.ENTITY_NOT_FOUND, "root entity {0} not found for id {1}", this.rootType, this.rootId)));
    }

    @Override
    public ResultSet<T> getAllByEntityType(Class<T> type, Query.PagingRequest pageReq) {
        return this.getQueryOperations().getAllChildByType(this.rootType, this.rootId, type, this.getTenantId(), pageReq);
    }

    @Override
    public <R extends RootEntity> RootEntityQueryContext<R> asRootQueryContext() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public ChildEntityQueryContext<R, T> asChildQueryContext() {
        return this;
    }

    @Override
    public ResultSet<Event<T>> getEntityEventsById(String id, Query.PagingRequest pageRequest) {
        return this.getQueryOperations().getEventsByChildId(this.rootType, this.rootId, this.entityType, id, this.getTenantId(), pageRequest);
    }

    @Override
    public <K> K executeRawQuery(String rawQuery) {
        return this.getQueryOperations().executeRawQuery(rawQuery);
    }

    @Override
    public <R extends RootEntity> AsyncEntityContext<R> asAsyncEntityContext() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public <R extends RootEntity> AsyncRootEntityQueryContext<R> asAsyncQueryContext() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public boolean isIdExist(String id, String tenantId) {
        return this.getQueryOperations().isIdExist(id, tenantId);
    }
}

