/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.runtime;

import com.cloudimpl.outstack.runtime.EntityContext;
import com.cloudimpl.outstack.runtime.EntityContextProvider;
import com.cloudimpl.outstack.runtime.EntityEventHandler;
import com.cloudimpl.outstack.runtime.ServiceProvider;
import com.cloudimpl.outstack.runtime.ServiceProviderException;
import com.cloudimpl.outstack.runtime.domainspec.Event;
import com.cloudimpl.outstack.runtime.domainspec.RootEntity;
import com.cloudimpl.outstack.runtime.util.Util;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class EventHandlerManager<T extends RootEntity> {
    private final Class<T> rootType;
    private final Map<String, List<EntityEventHandler>> mapEvtGroupHandlers;
    private final Map<String, EntityEventHandler> mapEvtHandlers;

    public EventHandlerManager(Class<T> rootType) {
        this.rootType = rootType;
        this.mapEvtHandlers = new HashMap<String, EntityEventHandler>();
        this.mapEvtGroupHandlers = new HashMap<String, List<EntityEventHandler>>();
    }

    public void register(Class<? extends EntityEventHandler> handlerType) {
        ServiceProvider.validateHandler(handlerType.getSimpleName().toLowerCase(), this.rootType, Util.extractGenericParameter(handlerType, EntityEventHandler.class, 0));
        EntityEventHandler exist = this.mapEvtHandlers.putIfAbsent(handlerType.getSimpleName().toLowerCase(), Util.createObject(handlerType, new Util.VarArg(new Class[0]), new Util.VarArg<Object>(new Object[0])));
        if (exist != null) {
            throw new ServiceProviderException("event handler {0} already exist ", handlerType.getSimpleName());
        }
        Class eventType = Util.extractGenericParameter(handlerType, EntityEventHandler.class, 1);
        List<EntityEventHandler> handlers = this.mapEvtGroupHandlers.get(eventType.getSimpleName());
        if (handlers == null) {
            handlers = new LinkedList<EntityEventHandler>();
            this.mapEvtGroupHandlers.put(eventType.getSimpleName(), handlers);
        }
        handlers.add(Util.createObject(handlerType, new Util.VarArg(new Class[0]), new Util.VarArg<Object>(new Object[0])));
    }

    public void emit(EntityContextProvider.Transaction<T> transaction, List<Event> events) {
        LinkedList<EntityContext> contexts = new LinkedList<EntityContext>();
        for (Event ev : events) {
            this.emitHandler(transaction, contexts, ev);
        }
        for (EntityContext context : contexts) {
            this.emit(transaction, context.getEvents());
        }
    }

    private void emitHandler(EntityContextProvider.Transaction<T> tx, List<EntityContext> contexts, Event event) {
        List<EntityEventHandler> handlers = this.mapEvtGroupHandlers.get(event.getClass().getSimpleName());
        if (handlers != null) {
            handlers.forEach(h -> contexts.add(h.emit(tx, event)));
        }
    }
}

