/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.runtime;

import com.cloudimpl.outstack.runtime.AsyncEntityContext;
import com.cloudimpl.outstack.runtime.AsyncRootEntityQueryContext;
import com.cloudimpl.outstack.runtime.CRUDOperations;
import com.cloudimpl.outstack.runtime.ChildEntityContext;
import com.cloudimpl.outstack.runtime.ChildEntityQueryContext;
import com.cloudimpl.outstack.runtime.EntityContext;
import com.cloudimpl.outstack.runtime.EntityIdHelper;
import com.cloudimpl.outstack.runtime.EntityProvider;
import com.cloudimpl.outstack.runtime.ITransaction;
import com.cloudimpl.outstack.runtime.QueryOperations;
import com.cloudimpl.outstack.runtime.ResultSet;
import com.cloudimpl.outstack.runtime.RootEntityQueryContext;
import com.cloudimpl.outstack.runtime.domainspec.ChildEntity;
import com.cloudimpl.outstack.runtime.domainspec.DomainEventException;
import com.cloudimpl.outstack.runtime.domainspec.Entity;
import com.cloudimpl.outstack.runtime.domainspec.EntityDeleted;
import com.cloudimpl.outstack.runtime.domainspec.EntityHelper;
import com.cloudimpl.outstack.runtime.domainspec.EntityRenamed;
import com.cloudimpl.outstack.runtime.domainspec.Event;
import com.cloudimpl.outstack.runtime.domainspec.Query;
import com.cloudimpl.outstack.runtime.domainspec.RootEntity;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class RootEntityContext<T extends RootEntity>
extends EntityContext<T>
implements RootEntityQueryContext<T> {
    private String _id;

    public RootEntityContext(Class<T> entityType, String tid, String tenantId, Optional<EntityProvider<? extends RootEntity>> entitySupplier, Supplier<String> idGenerator, Optional<CRUDOperations> crudOperations, QueryOperations<T> queryOperation, Optional<Consumer<Event>> eventPublisher, Consumer<Object> validator, Function<Class<? extends RootEntity>, QueryOperations<?>> queryOperationSelector, String version) {
        super(entityType, tenantId, entitySupplier, idGenerator, crudOperations, queryOperation, eventPublisher, validator, queryOperationSelector, version);
        this._id = tid;
    }

    @Override
    public RootEntityContext<T> asRootContext() {
        return this;
    }

    @Override
    public T create(String id, Event<T> event) {
        EntityIdHelper.validateEntityId(id);
        Objects.requireNonNull(event);
        this.validator.accept(event);
        if (this._id != null) {
            throw new DomainEventException(DomainEventException.ErrorCode.BASIC_VIOLATION, "rootId violation.", new Object[0]);
        }
        this.getEntityProvider().loadEntity(this.entityType, id, null, null, this.getTenantId()).ifPresent(e -> {
            throw new DomainEventException(DomainEventException.ErrorCode.ENTITY_EXIST, "root entity {0} already exist", ((RootEntity)e).getBRN());
        });
        EntityIdHelper.validateId(id, event);
        EntityHelper.setCreatedDate(event, System.currentTimeMillis());
        EntityHelper.setUserId(event, this.getTx().getInputMetaProvider().getUserId());
        EntityHelper.setUserName(event, this.getTx().getInputMetaProvider().getUserName());
        EntityHelper.setVersion(event, this.version);
        Object root = RootEntity.create(this.entityType, id, this.getTenantId(), (String)this.idGenerator.get());
        event.setTenantId(this.getTenantId());
        event.setId(((Entity)root).id());
        event.setRootId(((Entity)root).id());
        event.setAction(Event.Action.CREATE);
        EntityHelper.applyEvent(root, event);
        EntityHelper.setCreatedDate(root, event.getMeta().createdDate());
        EntityHelper.setUpdatedDate(root, event.getMeta().createdDate());
        EntityHelper.setUserId(root, this.getTx().getInputMetaProvider().getUserId());
        EntityHelper.setUserName(root, this.getTx().getInputMetaProvider().getUserName());
        this.validator.accept(root);
        this.addEvent(event);
        this._id = ((Entity)root).id();
        this.getCrudOperations().create((Entity)root);
        this.getEventPublisher().accept(event);
        return root;
    }

    public <C extends ChildEntity<T>> C create(Class<C> type, String id, Event<C> event) {
        ChildEntityContext childContext = new ChildEntityContext(this.entityType, this._id, type, this.getTenantId(), this.entitySupplier, this.idGenerator, this.crudOperations, this.queryOperation, this.eventPublisher, this.validator, this.queryOperationSelector, this.version);
        childContext.setTx(this.getTx());
        return (C)childContext.create(id, (Event)event);
    }

    public <C extends ChildEntity<T>> C create(Class<C> type, String rootId, String id, Event<C> event) {
        this.setId(rootId);
        return this.create(type, id, event);
    }

    public <C extends ChildEntity<T>> C update(Class<C> type, String id, Event<C> event) {
        ChildEntityContext childContext = new ChildEntityContext(this.entityType, this._id, type, this.getTenantId(), this.entitySupplier, this.idGenerator, this.crudOperations, this.queryOperation, this.eventPublisher, this.validator, this.queryOperationSelector, this.version);
        childContext.setTx(this.getTx());
        return (C)childContext.update(id, (Event)event);
    }

    public <C extends ChildEntity<T>> C rename(Class<C> type, String id, String newId) {
        ChildEntityContext childContext = new ChildEntityContext(this.entityType, this._id, type, this.getTenantId(), this.entitySupplier, this.idGenerator, this.crudOperations, this.queryOperation, this.eventPublisher, this.validator, this.queryOperationSelector, this.version);
        childContext.setTx(this.getTx());
        return (C)childContext.rename(id, newId);
    }

    @Override
    public T update(String id, Event<T> event) {
        Objects.requireNonNull(id);
        Objects.requireNonNull(event);
        this.validator.accept(event);
        if (this._id == null) {
            throw new DomainEventException(DomainEventException.ErrorCode.BASIC_VIOLATION, "root tid not available for entity {0}", this.entityType.getSimpleName());
        }
        RootEntity root = (RootEntity)this.getEntityProvider().loadEntity(this.entityType, id, null, null, this.getTenantId()).orElseThrow(() -> new DomainEventException(DomainEventException.ErrorCode.ENTITY_NOT_FOUND, "root entity not available for entity {0}", this.entityType.getSimpleName()));
        EntityIdHelper.validateId(id, root);
        EntityIdHelper.validateId(this._id, root);
        EntityHelper.setCreatedDate(event, System.currentTimeMillis());
        EntityHelper.setUserId(event, this.getTx().getInputMetaProvider().getUserId());
        EntityHelper.setUserName(event, this.getTx().getInputMetaProvider().getUserName());
        EntityHelper.setVersion(event, this.version);
        event.setTenantId(this.getTenantId());
        event.setId(root.id());
        event.setRootId(root.id());
        event.setAction(Event.Action.UPDATE);
        EntityHelper.applyEvent(root, event);
        EntityHelper.setUpdatedDate(root, event.getMeta().createdDate());
        EntityHelper.setUserId(root, this.getTx().getInputMetaProvider().getUserId());
        EntityHelper.setUserName(root, this.getTx().getInputMetaProvider().getUserName());
        this.validator.accept(root);
        EntityIdHelper.validateId(id, event);
        this.addEvent(event);
        this.getCrudOperations().update(root);
        this.getEventPublisher().accept(event);
        return (T)root;
    }

    @Override
    public T delete(String id) {
        Objects.requireNonNull(id);
        if (this._id == null) {
            throw new DomainEventException(DomainEventException.ErrorCode.BASIC_VIOLATION, "root tid not available for entity {0}", this.entityType.getSimpleName());
        }
        String temp = id;
        RootEntity root = (RootEntity)this.getEntityProvider().loadEntity(this.entityType, id, null, null, this.getTenantId()).orElseThrow(() -> new DomainEventException(DomainEventException.ErrorCode.ENTITY_NOT_FOUND, "root entity id {0} not available for entity {1}", temp, this.entityType.getSimpleName()));
        EntityIdHelper.validateId(id, root);
        EntityIdHelper.validateId(this._id, root);
        EntityDeleted event = new EntityDeleted(this.entityType, this.entityType, root.entityId(), root.entityId());
        event.setId(root.id());
        event.setRootId(root.id());
        event.setTenantId(this.getTenantId());
        event.setAction(Event.Action.DELETE);
        EntityHelper.setCreatedDate(event, System.currentTimeMillis());
        EntityHelper.setUserId(event, this.getTx().getInputMetaProvider().getUserId());
        EntityHelper.setUserName(event, this.getTx().getInputMetaProvider().getUserName());
        EntityHelper.setVersion(event, this.version);
        this.validator.accept(event);
        this.addEvent(event);
        this.getCrudOperations().delete(root);
        this.getEventPublisher().accept(event);
        return (T)root;
    }

    public <C extends ChildEntity<T>> C delete(Class<C> type, String id) {
        ChildEntityContext childContext = new ChildEntityContext(this.entityType, this._id, type, this.getTenantId(), this.entitySupplier, this.idGenerator, this.crudOperations, this.queryOperation, this.eventPublisher, this.validator, this.queryOperationSelector, this.version);
        childContext.setTx(this.getTx());
        return (C)childContext.delete(id);
    }

    @Override
    public T rename(String id, String newId) {
        EntityIdHelper.validateEntityId(id);
        EntityIdHelper.validateEntityId(newId);
        if (this._id == null) {
            throw new DomainEventException(DomainEventException.ErrorCode.BASIC_VIOLATION, "root tid not available for entity {0}", this.entityType.getSimpleName());
        }
        String temp = id;
        RootEntity root = (RootEntity)this.getEntityProvider().loadEntity(this.entityType, id, null, null, this.getTenantId()).orElseThrow(() -> new DomainEventException(DomainEventException.ErrorCode.ENTITY_NOT_FOUND, "root entity id {0} not available for entity {1}", temp, this.entityType.getSimpleName()));
        EntityIdHelper.validateId(id, root);
        EntityIdHelper.validateId(this._id, root);
        EntityRenamed event = new EntityRenamed(this.entityType, this.entityType, newId, id, newId);
        event.setTenantId(this.getTenantId());
        event.setId(root.id());
        event.setRootId(root.id());
        event.setAction(Event.Action.RENAME);
        EntityHelper.setCreatedDate(event, System.currentTimeMillis());
        EntityHelper.setUserId(event, this.getTx().getInputMetaProvider().getUserId());
        EntityHelper.setUserName(event, this.getTx().getInputMetaProvider().getUserName());
        EntityHelper.setVersion(event, this.version);
        this.validator.accept(event);
        this.addEvent(event);
        RootEntity old = root;
        root = (RootEntity)root.rename(newId);
        this.validator.accept(root);
        EntityHelper.setUpdatedDate(root, event.getMeta().createdDate());
        EntityHelper.setUserId(root, this.getTx().getInputMetaProvider().getUserId());
        EntityHelper.setUserName(root, this.getTx().getInputMetaProvider().getUserName());
        this.getCrudOperations().rename(old, root);
        this.getEventPublisher().accept(event);
        return (T)root;
    }

    @Override
    public ChildEntityContext asChildContext() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public Optional<T> getEntityById(String id) {
        return this.getQueryOperations().getRootById(this.entityType, id, this.getTenantId());
    }

    @Override
    public <C extends ChildEntity<T>> Optional<C> getChildEntityById(Class<C> childType, String id) {
        EntityIdHelper.validateTechnicalId(this._id);
        return this.getQueryOperations().getChildById(this.entityType, this._id, childType, id, this.getTenantId());
    }

    @Override
    public <C extends ChildEntity<T>> ResultSet<C> getAllChildEntitiesByType(Class<C> childType, Query.PagingRequest pageable) {
        return this.getQueryOperations().getAllChildByType(this.entityType, this._id, childType, this.getTenantId(), pageable);
    }

    @Override
    public RootEntityQueryContext<T> asRootQueryContext() {
        return this;
    }

    @Override
    public <R extends RootEntity, K extends ChildEntity<R>> ChildEntityQueryContext<R, K> asChildQueryContext() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public Optional<T> getEntity() {
        if (this._id == null) {
            return Optional.empty();
        }
        return this.getEntityById(this._id);
    }

    @Override
    public ResultSet<T> getAll(Query.PagingRequest pagingRequest) {
        return this.getQueryOperations().getAllByRootType(this.entityType, this.getTenantId(), pagingRequest);
    }

    @Override
    public <C extends ChildEntity<T>> ResultSet<Event<C>> getChildEntityEventsById(Class<C> childType, String id, Query.PagingRequest pageRequest) {
        return this.getQueryOperations().getEventsByChildId(this.entityType, this._id, childType, id, this.getTenantId(), pageRequest);
    }

    @Override
    public ResultSet<Event<T>> getEntityEventsById(String id, Query.PagingRequest pageRequest) {
        return this.getQueryOperations().getEventsByRootId(this.entityType, this._id, this.getTenantId(), pageRequest);
    }

    @Override
    public <K> K executeRawQuery(String rawQuery) {
        return this.getQueryOperations().executeRawQuery(rawQuery);
    }

    @Override
    public AsyncEntityContext<T> asAsyncEntityContext() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public AsyncRootEntityQueryContext<T> asAsyncQueryContext() {
        throw new UnsupportedOperationException("Not supported.");
    }

    private RootEntityContext<T> init(ITransaction tx, String id) {
        if (id != null) {
            this._id = ((RootEntity)this.getEntityById(id).get()).id();
        }
        this.setTx(tx);
        return this;
    }

    protected String getId() {
        return this._id;
    }

    @Override
    public RootEntityContext<T> asNonTenantContext(String id) {
        return new RootEntityContext(this.entityType, null, null, this.entitySupplier, this.idGenerator, this.crudOperations, this.getQueryOperations(), this.eventPublisher, this.validator, this.queryOperationSelector, this.version).init(this.getTx(), id);
    }

    protected void setId(String id) {
        if (!EntityIdHelper.isTechnicalId(id)) {
            id = ((RootEntity)this.getEntityById(id).orElseThrow(() -> new DomainEventException(DomainEventException.ErrorCode.ENTITY_NOT_FOUND, "root entity not available for entity {0}", this.entityType.getSimpleName()))).id();
        }
        if (this._id != null && !this._id.equals(id)) {
            throw new DomainEventException(DomainEventException.ErrorCode.BASIC_VIOLATION, "Root id violation", new Object[0]);
        }
        this._id = id;
    }

    @Override
    public boolean isIdExist(String id, String tenantId) {
        return this.getQueryOperations().isIdExist(id, tenantId);
    }
}

