/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.runtime;

import com.cloudimpl.outstack.runtime.AsyncEntityContext;
import com.cloudimpl.outstack.runtime.AsyncRootEntityQueryContext;
import com.cloudimpl.outstack.runtime.CRUDOperations;
import com.cloudimpl.outstack.runtime.ChildEntityContext;
import com.cloudimpl.outstack.runtime.ChildEntityQueryContext;
import com.cloudimpl.outstack.runtime.CommandResponse;
import com.cloudimpl.outstack.runtime.EntityContext;
import com.cloudimpl.outstack.runtime.EntityContextProvider;
import com.cloudimpl.outstack.runtime.EntityIdHelper;
import com.cloudimpl.outstack.runtime.EntityQueryContext;
import com.cloudimpl.outstack.runtime.ExternalEntityQueryProvider;
import com.cloudimpl.outstack.runtime.ITransaction;
import com.cloudimpl.outstack.runtime.QueryOperations;
import com.cloudimpl.outstack.runtime.ResultSet;
import com.cloudimpl.outstack.runtime.RootEntityContext;
import com.cloudimpl.outstack.runtime.RootEntityQueryContext;
import com.cloudimpl.outstack.runtime.domainspec.ChildEntity;
import com.cloudimpl.outstack.runtime.domainspec.Event;
import com.cloudimpl.outstack.runtime.domainspec.Query;
import com.cloudimpl.outstack.runtime.domainspec.RootEntity;
import java.text.MessageFormat;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import reactor.core.publisher.Mono;

public class UnboundedEntityContext<T extends RootEntity>
extends EntityContext<T>
implements EntityQueryContext {
    private EntityContextProvider entityContextProvider;
    private final BiFunction<String, Object, Mono> requestHandler;
    public static final CommandResponse OK = new CommandResponse("OK");

    public UnboundedEntityContext(EntityContextProvider entityContextProvider, Class<T> entityType, String tenantId, Supplier<String> idGenerator, Optional<CRUDOperations> crudOperations, QueryOperations<?> queryOperation, Optional<Consumer<Event>> eventPublisher, Consumer<Object> validator, Function<Class<? extends RootEntity>, QueryOperations<?>> queryOperationSelector, String version, BiFunction<String, Object, Mono> requestHandler) {
        super(entityType, tenantId, Optional.empty(), idGenerator, crudOperations, queryOperation, eventPublisher, validator, queryOperationSelector, version);
        this.entityContextProvider = entityContextProvider;
        this.requestHandler = requestHandler;
    }

    @Override
    public T create(String id, Event<T> event) {
        EntityIdHelper.validateEntityId(id);
        EntityContext entityContext = (EntityContext)((EntityContextProvider.UnboundedTransaction)this.getTx()).getTransaction(id).getContext(this.getEntityMeta().getType());
        return (T)entityContext.asRootContext().create(id, (Event)event);
    }

    @Override
    public T update(String id, Event<T> event) {
        EntityContext entityContext = (EntityContext)((EntityContextProvider.UnboundedTransaction)this.getTx()).getTransaction(id).getContext(this.getEntityMeta().getType());
        return (T)entityContext.asRootContext().update(id, (Event)event);
    }

    @Override
    public T delete(String id) {
        EntityContext entityContext = (EntityContext)((EntityContextProvider.UnboundedTransaction)this.getTx()).getTransaction(id).getContext(this.getEntityMeta().getType());
        return (T)entityContext.asRootContext().delete(id);
    }

    @Override
    public T rename(String id, String newId) {
        EntityContext entityContext = (EntityContext)((EntityContextProvider.UnboundedTransaction)this.getTx()).getTransaction(id).getContext(this.getEntityMeta().getType());
        return (T)entityContext.asRootContext().rename(id, newId);
    }

    @Override
    public UnboundedEntityContext<T> asUnboundedEntityContext() {
        return this;
    }

    @Override
    public Optional<T> getEntityById(String id) {
        return this.getQueryOperations().getRootById(this.entityType, id, this.getTenantId());
    }

    public ResultSet<Event> getEntityEventsById(String id, Query.PagingRequest pageRequest) {
        return null;
    }

    public Object executeRawQuery(String rawQuery) {
        return this.getQueryOperations().executeRawQuery(rawQuery);
    }

    @Override
    public ExternalEntityQueryProvider getEntityQueryProvider(Class rootType) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public AsyncRootEntityQueryContext asAsyncQueryContext() {
        throw new UnsupportedOperationException("Not supported.");
    }

    public ChildEntityQueryContext asChildQueryContext() {
        throw new UnsupportedOperationException("Not supported.");
    }

    public RootEntityQueryContext asRootQueryContext() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public <R extends RootEntity> RootEntityContext<R> asRootContext() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public <R extends RootEntity> AsyncEntityContext<R> asAsyncEntityContext() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public <R extends RootEntity, K extends ChildEntity<R>> ChildEntityContext<R, K> asChildContext() {
        throw new UnsupportedOperationException("Not supported.");
    }

    public <T> Mono<T> sendRequest(String domainOwner, String domainContext, String version, String serviceName, Object req) {
        return this.requestHandler.apply(MessageFormat.format("{0}/{1}/{2}/{3}", domainOwner, domainContext, version, serviceName), req);
    }

    public <R extends RootEntity> RootEntityContext<R> asNonTenantContext(String rootId) {
        EntityContext entityContext = (EntityContext)((EntityContextProvider.UnboundedTransaction)this.getTx()).getNonTenantTransaction(rootId).getContext(this.getEntityMeta().getType());
        return entityContext.asRootContext();
    }

    public <R extends RootEntity> RootEntityContext<R> asNonTenantContext(ITransaction tx, String rootId) {
        EntityContext entityContext = (EntityContext)tx.getContext(this.getEntityMeta().getType());
        return entityContext.asRootContext();
    }

    public <C extends ChildEntity<T>> C create(String rootId, Class<C> type, String id, Event<C> event) {
        EntityIdHelper.validateEntityId(id);
        EntityContext entityContext = (EntityContext)((EntityContextProvider.UnboundedTransaction)this.getTx()).getTransaction(rootId).getContext(this.getEntityMeta().getType());
        return entityContext.asRootContext().create(type, id, event);
    }

    public <C extends ChildEntity<T>> C update(String rootId, Class<C> type, String id, Event<C> event) {
        EntityContext entityContext = (EntityContext)((EntityContextProvider.UnboundedTransaction)this.getTx()).getTransaction(rootId).getContext(this.getEntityMeta().getType());
        return entityContext.asRootContext().update(type, id, event);
    }

    public <C extends ChildEntity<T>> C delete(String rootId, Class<C> type, String id) {
        EntityContext entityContext = (EntityContext)((EntityContextProvider.UnboundedTransaction)this.getTx()).getTransaction(rootId).getContext(this.getEntityMeta().getType());
        return entityContext.asRootContext().delete(type, id);
    }

    public <C extends ChildEntity<T>> Optional<C> getChildEntityById(String rootId, Class<C> childType, String id) {
        EntityContext entityContext = (EntityContext)((EntityContextProvider.UnboundedTransaction)this.getTx()).getTransaction(rootId).getContext(this.getEntityMeta().getType());
        return entityContext.asRootContext().getChildEntityById(childType, id);
    }

    public <C extends ChildEntity<T>> ResultSet<C> getAllChildEntitiesByType(String rootId, Class<C> childType, Query.PagingRequest pageable) {
        EntityContext entityContext = (EntityContext)((EntityContextProvider.UnboundedTransaction)this.getTx()).getTransaction(rootId).getContext(this.getEntityMeta().getType());
        return entityContext.asRootContext().getAllChildEntitiesByType(childType, pageable);
    }

    @Override
    public boolean isIdExist(String id, String tenantId) {
        return this.getQueryOperations().isIdExist(id, tenantId);
    }
}

