/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.runtime.configs;

import com.cloudimpl.outstack.runtime.configs.ConfigGroupCreated;
import com.cloudimpl.outstack.runtime.domainspec.DomainEventException;
import com.cloudimpl.outstack.runtime.domainspec.EntityMeta;
import com.cloudimpl.outstack.runtime.domainspec.Event;
import com.cloudimpl.outstack.runtime.domainspec.ITenantOptional;
import com.cloudimpl.outstack.runtime.domainspec.Id;
import com.cloudimpl.outstack.runtime.domainspec.RootEntity;

@EntityMeta(plural="config-group-entities", version="v1")
public class ConfigGroupEntity
extends RootEntity
implements ITenantOptional {
    @Id
    private final String groupName;
    private final String tenantId;

    public ConfigGroupEntity(String groupName, String tenantId) {
        this.groupName = groupName;
        this.tenantId = tenantId;
    }

    public String getGroupName() {
        return this.groupName;
    }

    @Override
    public String entityId() {
        return this.groupName;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    private void applyEvent(ConfigGroupCreated configGroupCreatedEvent) {
    }

    @Override
    protected void apply(Event event) {
        switch (event.getClass().getSimpleName()) {
            case "ConfigGroupCreated": {
                this.applyEvent((ConfigGroupCreated)event);
                break;
            }
            default: {
                throw new DomainEventException(DomainEventException.ErrorCode.UNHANDLED_EVENT, "unhandled event:" + event.getClass().getName(), new Object[0]);
            }
        }
    }

    @Override
    public String idField() {
        return "groupName";
    }
}

