/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.runtime.domain;

import com.cloudimpl.outstack.runtime.domain.PolicyStatementCreated;
import com.cloudimpl.outstack.runtime.domain.PolicyStatementUpdated;
import com.cloudimpl.outstack.runtime.domainspec.DomainEventException;
import com.cloudimpl.outstack.runtime.domainspec.EntityMeta;
import com.cloudimpl.outstack.runtime.domainspec.Event;
import com.cloudimpl.outstack.runtime.domainspec.ITenantOptional;
import com.cloudimpl.outstack.runtime.domainspec.Id;
import com.cloudimpl.outstack.runtime.domainspec.RootEntity;
import com.cloudimpl.outstack.runtime.iam.ActionDescriptor;
import com.cloudimpl.outstack.runtime.iam.ResourceDescriptor;
import java.util.Collection;
import java.util.Collections;

@EntityMeta(plural="PolicyStatements", version="v1")
public class PolicyStatement
extends RootEntity
implements ITenantOptional {
    @Id
    private final String sid;
    private EffectType effect;
    private String domainContext;
    private String domainOwner;
    private Collection<ActionDescriptor> cmdActions;
    private Collection<ActionDescriptor> queryActions;
    private Collection<ResourceDescriptor> resources;
    private Collection<String> tags;
    private final String tenantId;

    public PolicyStatement(String sid, String tenantId) {
        this.sid = sid;
        this.tenantId = tenantId;
        this.cmdActions = Collections.EMPTY_LIST;
        this.queryActions = Collections.EMPTY_LIST;
        this.resources = Collections.EMPTY_LIST;
        this.tags = Collections.EMPTY_SET;
    }

    public Collection<ActionDescriptor> getCmdActions() {
        return this.cmdActions;
    }

    public Collection<ActionDescriptor> getQueryActions() {
        return this.queryActions;
    }

    public EffectType getEffect() {
        return this.effect;
    }

    public Collection<ResourceDescriptor> getResources() {
        return this.resources;
    }

    public String getSid() {
        return this.sid;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    public boolean isQueryActionMatched(String action) {
        return this.queryActions.stream().filter(ad -> ad.isActionMatched(action)).findFirst().isPresent();
    }

    public boolean isCmdActionMatched(String action) {
        return this.cmdActions.stream().filter(ad -> ad.isActionMatched(action)).findFirst().isPresent();
    }

    @Override
    public String entityId() {
        return this.sid;
    }

    public String getDomainContext() {
        return this.domainContext;
    }

    public String getDomainOwner() {
        return this.domainOwner;
    }

    private void applyEvent(PolicyStatementCreated stmtCreated) {
        this.effect = stmtCreated.getEffect();
        this.cmdActions = stmtCreated.getCmdActions();
        this.queryActions = stmtCreated.getQueryActions();
        this.domainOwner = stmtCreated.getDomainOwner();
        this.domainContext = stmtCreated.getDomainContext();
        this.resources = stmtCreated.getResources();
    }

    private void applyEvent(PolicyStatementUpdated stmtUpdated) {
        this.effect = stmtUpdated.getEffect();
        this.cmdActions = stmtUpdated.getCmdActions();
        this.queryActions = stmtUpdated.getQueryActions();
        this.resources = stmtUpdated.getResources();
    }

    @Override
    protected void apply(Event event) {
        switch (event.getClass().getSimpleName()) {
            case "PolicyStatementCreated": {
                this.applyEvent((PolicyStatementCreated)event);
                break;
            }
            case "PolicyStatementUpdated": {
                this.applyEvent((PolicyStatementUpdated)event);
                break;
            }
            default: {
                throw new DomainEventException(DomainEventException.ErrorCode.UNHANDLED_EVENT, "unhandled event:" + event.getClass().getName(), new Object[0]);
            }
        }
    }

    @Override
    public String idField() {
        return "sid";
    }

    @Override
    public String toString() {
        return "PolicyStatement{sid=" + this.sid + ", effect=" + this.effect + ", cmdActions=" + this.cmdActions + ", queryActions=" + this.queryActions + ", resources=" + this.resources + ", tenantId=" + this.tenantId + "}";
    }

    public static enum EffectType {
        ALLOW,
        DENY;

    }
}

