/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.runtime.domainspec;

import com.cloudimpl.outstack.runtime.EntityIdHelper;
import com.cloudimpl.outstack.runtime.domainspec.ChildEntity;
import com.cloudimpl.outstack.runtime.domainspec.DomainEventException;
import com.cloudimpl.outstack.runtime.domainspec.Entity;
import com.cloudimpl.outstack.runtime.domainspec.Event;
import com.cloudimpl.outstack.runtime.domainspec.ITenant;
import com.cloudimpl.outstack.runtime.domainspec.ITenantOptional;
import com.cloudimpl.outstack.runtime.domainspec.RootEntity;
import com.cloudimpl.outstack.runtime.domainspec.TenantRequirement;
import com.cloudimpl.outstack.runtime.util.Util;
import java.util.Objects;

public class EntityHelper {
    public static void updateId(Entity entity, String id) {
        entity.setTid(id);
    }

    public static void updateRootId(ChildEntity entity, String rootId) {
        entity.setRootId(rootId);
    }

    public static <T extends Entity> boolean hasTenant(Class<T> entityType) {
        return ITenant.class.isAssignableFrom(entityType);
    }

    public static <T extends Entity> boolean hasOptionalTenant(Class<T> entityType) {
        return ITenantOptional.class.isAssignableFrom(entityType);
    }

    public static void setCreatedDate(Entity e, long millis) {
        e.getMeta().setCreatedDate(millis);
    }

    public static void applyEvent(Entity e, Event event) {
        e.applyEvent(event);
    }

    public static void setUserId(Entity e, String userId) {
        e.getMeta().setUserId(userId);
    }

    public static void setUserName(Entity e, String userName) {
        e.getMeta().setUserName(userName);
    }

    public static void setUpdatedDate(Entity e, long millis) {
        e.getMeta().setUpdatedDate(millis);
    }

    public static void setCreatedDate(Event e, long millis) {
        e.getMeta().setCreatedDate(millis);
    }

    public static void setUserId(Event e, String userId) {
        e.getMeta().setUserId(userId);
    }

    public static void setUserName(Event e, String userName) {
        e.getMeta().setUserName(userName);
    }

    public static void setLastEq(Entity e, long lastSeq) {
        e.getMeta().setLastSeq(lastSeq);
    }

    public static void validateEvent(Class<? extends RootEntity> rootType, Event event) {
        if (event.getRootOwner() != rootType) {
            throw new DomainEventException(DomainEventException.ErrorCode.BASIC_VIOLATION, "root entity type {0} mismatched with event root owner {1}", rootType, event.getRootOwner());
        }
    }

    public static Class<? extends RootEntity> getRootType(Class<? extends ChildEntity> childType) {
        return Util.extractGenericParameter(childType, ChildEntity.class, 0);
    }

    public static void setVersion(Event e, String version) {
        e.getMeta().setVersion(version);
    }

    public static <T extends Entity> boolean isRootEntity(Class<T> entityType) {
        return RootEntity.isMyType(entityType);
    }

    public static <T extends Entity> T createEntity(Class<T> type, Event event) {
        if (event.isRootEvent()) {
            if (event.tenantId() != null) {
                return (T)((Entity)Util.createObject(type, new Util.VarArg(String.class, String.class), new Util.VarArg<Object>(event.entityId(), event.tenantId())));
            }
            return (T)((Entity)Util.createObject(type, new Util.VarArg(String.class), new Util.VarArg<Object>(event.entityId())));
        }
        if (event.tenantId() != null) {
            return (T)((Entity)Util.createObject(type, new Util.VarArg(String.class, String.class, String.class), new Util.VarArg<Object>(event.rootEntityId(), event.entityId(), event.tenantId())));
        }
        return (T)((Entity)Util.createObject(type, new Util.VarArg(String.class, String.class), new Util.VarArg<Object>(event.rootEntityId(), event.entityId())));
    }

    public static <T extends RootEntity> T createRootEntity(Class<T> type, String entityId, String tenantId) {
        if (!EntityHelper.isRootEntity(type)) {
            throw new DomainEventException(DomainEventException.ErrorCode.INVALID_ENTITY_TYPE, "type {0} not a root entity", type.getClass().getName());
        }
        if (tenantId != null) {
            return (T)((RootEntity)Util.createObject(type, new Util.VarArg(String.class, String.class), new Util.VarArg<Object>(entityId, tenantId)));
        }
        return (T)((RootEntity)Util.createObject(type, new Util.VarArg(String.class), new Util.VarArg<Object>(entityId)));
    }

    public static <R extends RootEntity, T extends ChildEntity<R>> T createChildEntity(Class<? extends RootEntity> rootType, String rootId, Class<T> childType, String entityId, String tenantId, String id) {
        EntityIdHelper.validateTechnicalId(id);
        TenantRequirement tr = Entity.checkTenantRequirement(rootType);
        ChildEntity t = switch (tr) {
            case TenantRequirement.REQUIRED -> {
                Objects.requireNonNull(tenantId);
                yield (ChildEntity)Util.createObject(childType, new Util.VarArg(String.class, String.class), new Util.VarArg<Object>(entityId, tenantId));
            }
            case TenantRequirement.OPTIONAL -> (ChildEntity)Util.createObject(childType, new Util.VarArg(String.class, String.class), new Util.VarArg<Object>(entityId, tenantId));
            default -> (ChildEntity)Util.createObject(childType, new Util.VarArg(String.class), new Util.VarArg<Object>(entityId));
        };
        EntityHelper.updateId(t, id);
        EntityHelper.updateRootId(t, rootId);
        return (T)t;
    }
}

