/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.runtime.iam;

import com.cloudimpl.outstack.runtime.domainspec.AuthInput;
import java.util.Map;

public class ResourceDescriptor {
    private static final String PREFIX_ID = "ignoreCase#";
    private final ResourceScope resourceScope;
    private final TenantScope tenantScope;
    private final String version;
    private final String tenantId;
    private final String rootType;
    private final String rootId;
    private final String childType;
    private final String childId;

    private ResourceDescriptor(Builder builder) {
        this.version = builder.version;
        this.tenantId = builder.tenantId;
        this.rootType = builder.rootType;
        this.rootId = builder.rootId;
        this.childType = builder.childType;
        this.childId = builder.childId;
        this.resourceScope = builder.resourceScope;
        this.tenantScope = builder.tenantScope;
    }

    public boolean isResourceMatched(AuthInput input, Map<String, Object> attr) {
        if (!this.validateTenantScope(attr)) {
            return false;
        }
        switch (this.resourceScope) {
            case GLOBAL: {
                return true;
            }
            case ALL: 
            case ALL_ROOT_ID_ONLY: {
                return this.rootType.toLowerCase().equals(input.getRootType().toLowerCase());
            }
            case ALL_ROOT_ID_CHILD_TYPE_ONLY: {
                if (input.getRootId() == null || input.getChildType() == null) {
                    return false;
                }
                return input.getChildType().equals(this.childType);
            }
            case ROOT_ID_CHILD_TYPE_ONLY: {
                if (input.getRootId() == null || input.getChildType() == null) {
                    return false;
                }
                return this.validateIdIgnoreCase(input.getRootId(), this.rootId) && input.getChildType().equals(this.childType);
            }
            case ROOT_ID_ONLY: {
                if (input.getRootId() == null) {
                    return false;
                }
                return this.validateIdIgnoreCase(input.getRootId(), this.rootId);
            }
            case ROOT_ID_CHILD_ID_ONLY: {
                if (input.getRootId() == null || input.getChildType() == null || input.getId() == null) {
                    return false;
                }
                return this.validateIdIgnoreCase(input.getRootId(), this.rootId) && input.getChildType().equals(this.childType) && input.getId().equals(this.childId);
            }
            case ALL_ROOT_ID_CHILD_ID_ONLY: {
                if (input.getRootId() == null || input.getChildType() == null || input.getId() == null) {
                    return false;
                }
                return input.getChildType().equals(this.childType) && input.getId().equals(this.childId);
            }
        }
        return false;
    }

    private boolean validateIdIgnoreCase(String inputId, String id) {
        if (id.startsWith(PREFIX_ID)) {
            String idIgnoreCase = id.substring(PREFIX_ID.length());
            return inputId.equalsIgnoreCase(idIgnoreCase);
        }
        return inputId.equals(id);
    }

    private boolean validateTenantScope(Map<String, Object> attr) {
        switch (this.tenantScope) {
            case ALL: {
                String tid = (String)attr.get("tenantId");
                return tid != null;
            }
            case TENANT_ID: {
                String tid = (String)attr.get("tenantId");
                if (tid == null) {
                    return false;
                }
                return tid.equals(this.tenantId);
            }
            case NONE: {
                return true;
            }
        }
        return false;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getRootType() {
        return this.rootType;
    }

    public String getRootId() {
        return this.rootId;
    }

    public String getChildType() {
        return this.childType;
    }

    public String getChildId() {
        return this.childId;
    }

    public String getVersion() {
        return this.version;
    }

    public ResourceScope getResourceScope() {
        return this.resourceScope;
    }

    public TenantScope getTenantScope() {
        return this.tenantScope;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean isTenantResource() {
        return this.tenantScope != TenantScope.NONE;
    }

    public String toString() {
        return "ResourceDescriptor{resourceScope=" + this.resourceScope + ", tenantScope=" + this.tenantScope + ", version=" + this.version + ", tenantId=" + this.tenantId + ", rootType=" + this.rootType + ", rootId=" + this.rootId + ", childType=" + this.childType + ", childId=" + this.childId + "}";
    }

    public static final class Builder {
        private String version;
        private String tenantId;
        private String rootType;
        private String rootId;
        private String childType;
        private String childId;
        private ResourceScope resourceScope;
        private TenantScope tenantScope;

        public Builder withTenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public Builder withVersion(String version) {
            this.version = version;
            return this;
        }

        public Builder withRootType(String rootType) {
            this.rootType = rootType;
            return this;
        }

        public Builder withRootId(String rootId) {
            this.rootId = rootId;
            return this;
        }

        public Builder withChildType(String childType) {
            this.childType = childType;
            return this;
        }

        public Builder withChildId(String childId) {
            this.childId = childId;
            return this;
        }

        public Builder withResourceScope(ResourceScope scope) {
            this.resourceScope = scope;
            return this;
        }

        public Builder withTenantScope(TenantScope scope) {
            this.tenantScope = scope;
            return this;
        }

        public ResourceDescriptor build() {
            return new ResourceDescriptor(this);
        }
    }

    public static enum ResourceScope {
        NONE,
        GLOBAL,
        VERSION_ONLY,
        ALL,
        ALL_ROOT_ID_ONLY,
        ALL_ROOT_ID_CHILD_TYPE_ONLY,
        ROOT_ID_CHILD_TYPE_ONLY,
        ROOT_ID_ONLY,
        ROOT_ID_CHILD_ID_ONLY,
        ALL_ROOT_ID_CHILD_ID_ONLY;

    }

    public static enum TenantScope {
        NONE,
        ALL,
        TENANT_ID;

    }
}

