/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.runtime.util;

import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class TimeUtils {
    private static long offset = 0L;
    private static DateTimeZone zone = DateTimeZone.forID((String)"EST5EDT");

    public static long getOffset() {
        return offset;
    }

    public boolean timeCheck(long transactTime) {
        return TimeUtils.getCurrentTime().minusMinutes(1).isAfter(transactTime);
    }

    public static long getDayFromMillis(long time) {
        return TimeUtils.fromEpoch(time).withHourOfDay(0).withMinuteOfHour(0).withSecondOfMinute(0).withMillisOfSecond(0).getMillis();
    }

    public static void setOffset(long offset) {
        TimeUtils.offset = offset;
    }

    public static void setZone(DateTimeZone zone) {
        TimeUtils.zone = zone;
    }

    public static long currentTimeMillis() {
        return offset == 0L ? System.currentTimeMillis() : TimeUtils.getCurrentTime().getMillis();
    }

    public static DateTime getCurrentTime() {
        return offset == 0L ? DateTime.now().withZone(zone) : DateTime.now().plus(offset).withZone(zone);
    }

    public static DateTime fromEpoch(long mills) {
        return new DateTime(mills).withZone(zone);
    }

    public static String fromEpochToString(long mills, DateTimeZone zone, String format) {
        return new DateTime(mills).withZone(zone).toString(format);
    }

    public static DateTime fromString(String string, String format, String zone) {
        DateTime dt = DateTime.parse((String)string, (DateTimeFormatter)DateTimeFormat.forPattern((String)format).withZone(DateTimeZone.forID((String)zone)));
        if (dt.getYear() != 1970) {
            return dt;
        }
        DateTime currentDate = TimeUtils.getCurrentTime();
        return dt.withYear(currentDate.getYear()).withMonthOfYear(currentDate.getMonthOfYear()).withDayOfMonth(currentDate.getDayOfMonth()).withMillisOfDay(0);
    }

    public static DateTime fromString(String string, String format) {
        DateTime dt = DateTime.parse((String)string, (DateTimeFormatter)DateTimeFormat.forPattern((String)format).withZone(zone));
        if (dt.getYear() != 1970) {
            return dt;
        }
        DateTime currentDate = TimeUtils.getCurrentTime();
        return dt.withYear(currentDate.getYear()).withMonthOfYear(currentDate.getMonthOfYear()).withDayOfMonth(currentDate.getDayOfMonth()).withMillisOfDay(0);
    }

    public static String toStringDateOnly(DateTime date) {
        return date.toString("MM/dd/yyyy");
    }

    public static String toStringTimeOnly(DateTime date) {
        return date.toString("h:mm a");
    }

    public static String toStringDateTime(DateTime date) {
        return date.toString("MM/dd/yyyy h:mm a");
    }

    public static DateTimeZone getTimezone() {
        return zone;
    }

    public static String millsToString(long mills) {
        long ms = mills % 1000L;
        long msx = mills / 1000L;
        long s = msx % 60L;
        long sx = msx / 60L;
        long m = sx % 60L;
        long h = sx / 60L;
        return String.format("%02d:%02d:%02d.%03d", h, m, s, ms);
    }

    public static String toStringDateTimeWithTimezone(DateTime date, String format) {
        return date.toString(format) + " EST";
    }
}

