package com.cloudimpl.outstack.collection.error;

import com.cloudimpl.error.core.CloudImplException;
import com.cloudimpl.error.core.ErrorBuilder;
import java.util.function.Consumer;

public class CollectionException extends CloudImplException {
  CollectionException(ErrorBuilder builder) {
    super(builder);
  }

  /**
   * errorNo : 1000 
   * format : "reflection error" 
   * tags : "[]"
   * @param consumer
   * @return
   */
  public static CollectionException RELECTION_EXCEPTION(Consumer<RELECTION_EXCEPTION> consumer) {
    RELECTION_EXCEPTION error = new RELECTION_EXCEPTION();
    consumer.accept(error);
    return new CollectionException(error);}

  /**
   * errorNo : 1001 
   * format : "[entity]:[id] doesn't exist" 
   * tags : "[entity, id]"
   * @param consumer
   * @return
   */
  public static CollectionException ROOT_DOESNT_EXIST(Consumer<ROOT_DOESNT_EXIST> consumer) {
    ROOT_DOESNT_EXIST error = new ROOT_DOESNT_EXIST();
    consumer.accept(error);
    return new CollectionException(error);}

  /**
   * errorNo : 1002 
   * format : "event [event] apply failed for entity [entity], invalid owner [owner]" 
   * tags : "[event, entity, owner]"
   * @param consumer
   * @return
   */
  public static CollectionException INVALID_OWNER(Consumer<INVALID_OWNER> consumer) {
    INVALID_OWNER error = new INVALID_OWNER();
    consumer.accept(error);
    return new CollectionException(error);}
}
