/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.workflow;

import com.cloudimpl.outstack.common.RetryUtil;
import com.cloudimpl.outstack.workflow.AtleastWorkFlow;
import com.cloudimpl.outstack.workflow.ParallelWorkflow;
import com.cloudimpl.outstack.workflow.PredicateWorkflow;
import com.cloudimpl.outstack.workflow.SequentialWorkflow;
import com.cloudimpl.outstack.workflow.Work;
import com.cloudimpl.outstack.workflow.WorkContext;
import com.cloudimpl.outstack.workflow.WorkStatus;
import com.cloudimpl.outstack.workflow.WorkUnit;
import com.cloudimpl.outstack.workflow.WorkflowEngine;
import com.cloudimpl.outstack.workflow.WorkflowException;
import com.google.gson.JsonObject;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.retry.Retry;
import reactor.retry.RetryContext;

public abstract class AbstractWork
implements Work {
    private static final Logger log = LoggerFactory.getLogger(AbstractWork.class);
    protected final String id;
    protected final String name;
    protected WorkflowEngine engine;
    protected BiFunction<String, WorkStatus, Mono<WorkStatus>> updateStateHandler;
    protected Function<String, Optional<WorkStatus>> workStatusLoader;
    protected Consumer<Object> autoWireHandler;

    public AbstractWork(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    protected void setEngine(WorkflowEngine engine) {
        this.engine = engine;
    }

    protected WorkflowEngine getEngine() {
        return this.engine;
    }

    public Mono<WorkStatus> run(WorkContext context) {
        return this.execute(context);
    }

    public void log(String format, Object ... args) {
        String msg = MessageFormat.format(format, args);
        log.info("workflow {}:{}:{} -> {} ", new Object[]{this.engine.getId(), this.getClass().getSimpleName(), this.name, msg});
    }

    protected Mono<WorkStatus> retryWrap(Work work, WorkContext context) {
        return Mono.fromSupplier(() -> work).flatMap(f -> f.execute(context)).doOnError(err -> this.error((Throwable)err, "error:", new Object[0])).retryWhen(RetryUtil.wrap((Retry)Retry.onlyIf(c -> this.isRetryable((RetryContext)c, context)).exponentialBackoffWithJitter(Duration.ofSeconds(5L), Duration.ofSeconds(60L))));
    }

    private boolean isRetryable(RetryContext retryContext, WorkContext context) {
        return this.getEngine().getStatus() == Work.Status.RUNNING;
    }

    public void error(Throwable thr, String format, Object ... args) {
        String msg = MessageFormat.format(format, args);
        log.error("workflow " + this.engine.getId() + ":" + this.getClass().getSimpleName() + ":" + this.name + " -> " + msg, thr);
    }

    protected WorkStatus merge(WorkStatus result, List<WorkStatus> contextList) {
        contextList.stream().forEach(c -> ((WorkContext)result.getData()).merge((WorkContext)c.getData()));
        return result;
    }

    protected void setHandlers(BiFunction<String, WorkStatus, Mono<WorkStatus>> updateStateHandler, Consumer<Object> autoWireHandler, Function<String, Optional<WorkStatus>> workStatusLoader) {
        this.updateStateHandler = updateStateHandler;
        this.autoWireHandler = autoWireHandler;
        this.workStatusLoader = workStatusLoader;
    }

    public static AbstractWork fromJson(JsonObject json) {
        String workFlow;
        switch (workFlow = json.get("workflowType").getAsString()) {
            case "com.cloudimpl.outstack.workflow.SequentialWorkflow": {
                return SequentialWorkflow.fromJson(json);
            }
            case "com.cloudimpl.outstack.workflow.WorkUnit": {
                return WorkUnit.fromJson(json);
            }
            case "com.cloudimpl.outstack.workflow.ParallelWorkflow": {
                return ParallelWorkflow.fromJson(json);
            }
            case "com.cloudimpl.outstack.workflow.PredicateWorkflow": {
                return PredicateWorkflow.fromJson(json);
            }
            case "com.cloudimpl.outstack.workflow.AtleastWorkFlow": {
                return AtleastWorkFlow.fromJson(json);
            }
        }
        throw new WorkflowException("unknown workflow type {}", workFlow);
    }
}

