/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.workflow;

import com.cloudimpl.outstack.workflow.AbstractWork;
import com.cloudimpl.outstack.workflow.Work;
import com.cloudimpl.outstack.workflow.WorkContext;
import com.cloudimpl.outstack.workflow.WorkStatus;
import com.cloudimpl.outstack.workflow.Workflow;
import com.cloudimpl.outstack.workflow.WorkflowEngine;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import reactor.core.publisher.Mono;

public class SequentialWorkflow
extends Workflow {
    private final List<AbstractWork> workUnits;

    private SequentialWorkflow(String id, String name, List<AbstractWork> works) {
        super(id, name);
        this.workUnits = Collections.unmodifiableList(works);
    }

    @Override
    public Mono<WorkStatus> execute(WorkContext context) {
        this.log("exec started", new Object[0]);
        Mono ret = null;
        for (AbstractWork flow : this.workUnits) {
            if (ret == null) {
                ret = this.retryWrap(flow, context);
                continue;
            }
            ret = ret.flatMap(r -> this.retryWrap(flow, (WorkContext)r.getData()));
        }
        return ret == null ? Mono.empty() : ret.doOnNext(r -> this.log("done : {0}", new Object[]{r.getStatus()}));
    }

    @Override
    protected void setEngine(WorkflowEngine engine) {
        this.engine = engine;
        this.workUnits.forEach(w -> w.setEngine(engine));
    }

    @Override
    protected void setHandlers(BiFunction<String, WorkStatus, Mono<WorkStatus>> updateStateHandler, Consumer<Object> autoWireHandler, Function<String, Optional<WorkStatus>> workStatusLoader) {
        super.setHandlers(updateStateHandler, autoWireHandler, workStatusLoader);
        this.workUnits.forEach(w -> w.setHandlers(updateStateHandler, autoWireHandler, workStatusLoader));
    }

    public static final ExecuteStep name(String name) {
        Builder builder = new Builder(name);
        return new ExecuteStep(builder);
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("id", this.getId());
        json.addProperty("workflowType", SequentialWorkflow.class.getName());
        json.addProperty("name", this.name);
        JsonArray arr = new JsonArray();
        this.workUnits.stream().forEach(w -> arr.add((JsonElement)w.toJson()));
        json.add("workUnits", (JsonElement)arr);
        return json;
    }

    public static SequentialWorkflow fromJson(JsonObject json) {
        JsonArray arr = json.getAsJsonArray("workUnits");
        LinkedList<AbstractWork> workunits = new LinkedList<AbstractWork>();
        arr.forEach(w -> workunits.add(AbstractWork.fromJson(w.getAsJsonObject())));
        SequentialWorkflow workflow = new SequentialWorkflow(json.get("id").getAsString(), json.get("name").getAsString(), workunits);
        return workflow;
    }

    public static final class Builder {
        private String name;
        private final List<AbstractWork> works = new LinkedList<AbstractWork>();

        public Builder(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static final class ExecuteStep {
        private final Builder builder;

        public ExecuteStep(Builder builder) {
            this.builder = builder;
        }

        public final ThenStep execute(AbstractWork work) {
            return new ThenStep(this.builder).then(work);
        }
    }

    public static final class ThenStep {
        private final Builder builder;

        public ThenStep(Builder builder) {
            this.builder = builder;
        }

        public ThenStep then(AbstractWork work) {
            this.builder.works.add(work);
            return this;
        }

        public SequentialWorkflow build() {
            return new SequentialWorkflow(Work.generateId(), this.builder.name, this.builder.works);
        }
    }
}

