/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.workflow.example;

import com.cloudimpl.outstack.workflow.ParallelWorkflow;
import com.cloudimpl.outstack.workflow.SequentialWorkflow;
import com.cloudimpl.outstack.workflow.Work;
import com.cloudimpl.outstack.workflow.WorkContext;
import com.cloudimpl.outstack.workflow.WorkStatus;
import com.cloudimpl.outstack.workflow.WorkUnit;
import com.cloudimpl.outstack.workflow.WorkflowEngine;
import reactor.core.publisher.Mono;

public class Example2 {
    public static void main(String[] args) throws InterruptedException {
        ParallelWorkflow parallel = ParallelWorkflow.name("p1").execute(WorkUnit.of("work3", new DynamicWork("work3")).build(), WorkUnit.of("work4", new DynamicWork("work4")).build()).build();
        SequentialWorkflow sequential = SequentialWorkflow.name("seq1").execute(WorkUnit.of("work1", new Work1()).build()).then(WorkUnit.of("work2", new DynamicWork("work2")).build()).then(parallel).build();
        WorkflowEngine engine = new WorkflowEngine("1");
        engine.execute(sequential).subscribe();
        Thread.sleep(10000000L);
    }

    public static class DynamicWork
    implements Work {
        private String msg;

        public DynamicWork(String msg) {
            this.msg = msg;
        }

        @Override
        public Mono<WorkStatus> execute(WorkContext context) {
            System.out.println(this.msg + " executed at " + Thread.currentThread().getName());
            return Mono.just((Object)WorkStatus.publish(Work.Status.COMPLETED, context));
        }
    }

    public static class Work1
    implements Work {
        @Override
        public Mono<WorkStatus> execute(WorkContext context) {
            System.out.println("work1 executed at " + Thread.currentThread().getName());
            return Mono.just((Object)WorkStatus.publish(Work.Status.COMPLETED, context));
        }
    }

    public static class BuggyWork
    implements Work {
        private String msg;

        public BuggyWork(String msg) {
            this.msg = msg;
        }

        @Override
        public Mono<WorkStatus> execute(WorkContext context) {
            return Mono.error(() -> new RuntimeException("buggy"));
        }
    }
}

