/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.workflow;

import com.cloudimpl.outstack.common.GsonCodec;
import com.cloudimpl.outstack.core.CloudUtil;
import com.cloudimpl.outstack.workflow.AbstractWork;
import com.cloudimpl.outstack.workflow.ExternalTrigger;
import com.cloudimpl.outstack.workflow.GateTrigger;
import com.cloudimpl.outstack.workflow.StatefullWork;
import com.cloudimpl.outstack.workflow.Work;
import com.cloudimpl.outstack.workflow.WorkContext;
import com.cloudimpl.outstack.workflow.WorkStatus;
import com.cloudimpl.outstack.workflow.WorkflowEngine;
import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import reactor.core.publisher.Mono;

public class WorkUnit
extends AbstractWork {
    private final Class<? extends Work> workUnit;
    private final String content;
    protected CompletableFuture<WorkStatus> gateFuture;

    private WorkUnit(String id, String name, Class<? extends Work> work, String content) {
        super(id, name);
        System.out.println("workuni : " + id + " " + name);
        this.workUnit = work;
        this.content = content;
    }

    @Override
    public synchronized Mono<WorkStatus> execute(WorkContext context) {
        Optional<WorkStatus> status = this.loadWorkStatus();
        if (status.isPresent()) {
            return Mono.just((Object)status.get());
        }
        WorkContext copy = this.isStateful() ? context.clone(false) : context.clone(true);
        Work workItem = (Work)GsonCodec.decode(this.workUnit, (String)this.content);
        if (this.autoWireHandler != null) {
            this.autoWireHandler.accept(workItem);
        }
        if (workItem instanceof ExternalTrigger) {
            ((ExternalTrigger)ExternalTrigger.class.cast(workItem)).init(this);
            this.getEngine().registerExternalTrigger(this.getName(), (ExternalTrigger)workItem);
        }
        Mono ret = workItem.execute(copy).doOnNext(s -> this.mergeIfPossible(copy, (WorkContext)s.getData())).doOnNext(r -> copy.getStatus(this.id).set(r.getStatus()));
        if (workItem instanceof StatefullWork) {
            ret = ret.flatMap(r -> (Mono)this.updateStateHandler.apply(this.getId(), WorkStatus.publish(r.getStatus(), copy)));
        }
        return ret.doOnSuccess(s -> this.removeActiveTrigger(workItem instanceof ExternalTrigger)).map(r -> WorkStatus.publish(this.isStateful() ? r.getStatus() : Work.Status.COMPLETED, copy)).doOnNext(r -> this.log("done : {0}", new Object[]{r.getStatus()})).doOnNext(r -> this.cancelRestIfApplicable((WorkStatus)r)).doOnError(e -> this.error((Throwable)e, "WorkUnit {0} error", this.getName()));
    }

    private void mergeIfPossible(WorkContext dest, WorkContext source) {
        if (!dest.isImmutable() && source != null && dest != source) {
            dest.merge(source);
        }
    }

    private Optional<WorkStatus> loadWorkStatus() {
        return (Optional)this.workStatusLoader.apply(this.getId());
    }

    private void cancelRestIfApplicable(WorkStatus status) {
        if (status.getStatus() == Work.Status.CANCELLED) {
            this.getEngine().cancel();
        }
    }

    private boolean isStateful() {
        return StatefullWork.class.isAssignableFrom(this.workUnit);
    }

    private void removeActiveTrigger(boolean isTrigger) {
        if (isTrigger) {
            this.getEngine().removeActiveTrigger(this.getName());
        }
    }

    @Override
    protected void setEngine(WorkflowEngine engine) {
        super.setEngine(engine);
        if (ExternalTrigger.class.isAssignableFrom(this.workUnit)) {
            engine.checkTriggerDuplicate(this.getName());
        }
        if (GateTrigger.class.isAssignableFrom(this.workUnit)) {
            this.gateFuture = new CompletableFuture();
            GateTrigger gate = new GateTrigger();
            gate.init(this);
            this.getEngine().registerExternalTrigger(this.getName(), gate);
        }
    }

    public static Builder of(String name, Work work) {
        return new Builder(name, work);
    }

    public static WorkUnit waitFor(String name, Map<String, String> labels) {
        return WorkUnit.of(name, new ExternalTrigger().putLabel(labels)).build();
    }

    public static WorkUnit waitFor(String name) {
        return WorkUnit.waitFor(name, Collections.EMPTY_MAP);
    }

    public static WorkUnit gateFor(String name, Map<String, String> labels) {
        return WorkUnit.of(name, new GateTrigger().putLabel(labels)).build();
    }

    public static WorkUnit gateFor(String name) {
        return WorkUnit.gateFor(name, Collections.EMPTY_MAP);
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("id", this.id);
        json.addProperty("name", this.name);
        json.addProperty("workflowType", WorkUnit.class.getName());
        json.addProperty("workUnit", this.workUnit.getName());
        json.addProperty("content", this.content);
        return json;
    }

    public static WorkUnit fromJson(JsonObject json) {
        String workUnit = json.get("workUnit").getAsString();
        return new WorkUnit(json.get("id").getAsString(), json.get("name").getAsString(), CloudUtil.classForName((String)workUnit), json.getAsJsonPrimitive("content").getAsString());
    }

    public static class Builder {
        private Work work;
        private String name;

        public Builder(String name, Work work) {
            this.name = name;
            this.work = work;
        }

        public WorkUnit build() {
            return new WorkUnit(Work.generateId(), this.name, this.work.getClass(), GsonCodec.encode((Object)this.work));
        }
    }
}

