/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.workflow.example;

import com.cloudimpl.outstack.workflow.ParallelWorkflow;
import com.cloudimpl.outstack.workflow.SequentialWorkflow;
import com.cloudimpl.outstack.workflow.StatefullWork;
import com.cloudimpl.outstack.workflow.Work;
import com.cloudimpl.outstack.workflow.WorkContext;
import com.cloudimpl.outstack.workflow.WorkStatus;
import com.cloudimpl.outstack.workflow.WorkUnit;
import com.cloudimpl.outstack.workflow.WorkflowEngine;
import reactor.core.publisher.Mono;

public class CancelTest {
    public static void main(String[] args) throws InterruptedException {
        SequentialWorkflow seq = SequentialWorkflow.name("seq1").execute(WorkUnit.of("work1", new DynamicWork("work1")).build()).then(WorkUnit.of("work2", new DynamicWork("work2")).build()).then(WorkUnit.waitFor("work3")).then(ParallelWorkflow.name("parallel").execute(WorkUnit.waitFor("work4"), WorkUnit.waitFor("work5")).build()).build();
        WorkflowEngine engine = new WorkflowEngine("2");
        engine.execute(seq).doOnNext(s -> System.out.println(s)).subscribe();
        Thread.sleep(5000L);
        engine.executeAsyncNext(c -> {
            c.put("1", "work3");
            return Mono.just((Object)WorkStatus.publish(Work.Status.CANCELLED, "hello"));
        }).subscribe();
        Thread.sleep(1000L);
        Thread.sleep(5000L);
        engine.executeAsync("work4", c -> {
            c.put("1", "work4");
            return Mono.just((Object)"hello");
        }).subscribe();
        engine.executeAsync("work5", c -> {
            c.put("1", "work5");
            return Mono.just((Object)"hello");
        }).subscribe();
        Thread.sleep(500000000L);
    }

    public static final class DynamicWork
    implements StatefullWork {
        private String msg;

        public DynamicWork(String msg) {
            this.msg = msg;
        }

        @Override
        public Mono<WorkStatus> execute(WorkContext context) {
            context.put(this.msg, this.msg);
            if (this.msg.equals("work1")) {
                return Mono.just((Object)WorkStatus.publish(Work.Status.COMPLETED));
            }
            if (this.msg.equals("work2")) {
                return Mono.just((Object)WorkStatus.publish(Work.Status.COMPLETED));
            }
            return Mono.just((Object)WorkStatus.publish(Work.Status.COMPLETED));
        }
    }
}

