/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.workflow.example;

import com.cloudimpl.outstack.common.GsonCodec;
import com.cloudimpl.outstack.workflow.ParallelWorkflow;
import com.cloudimpl.outstack.workflow.SequentialWorkflow;
import com.cloudimpl.outstack.workflow.Work;
import com.cloudimpl.outstack.workflow.WorkContext;
import com.cloudimpl.outstack.workflow.WorkStatus;
import com.cloudimpl.outstack.workflow.WorkUnit;
import com.cloudimpl.outstack.workflow.WorkflowEngine;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import reactor.core.publisher.Mono;

public class Example {
    public static void main(String[] args) throws InterruptedException {
        String data = GsonCodec.encode((Object)new Test());
        System.out.println(data);
        Test k = (Test)GsonCodec.decode(Test.class, (String)data);
        System.out.println((Object)k.stats.get("asfas").get());
        SequentialWorkflow sequence = SequentialWorkflow.name("seq1").execute(WorkUnit.of("work1", new Work2(Arrays.asList("nuwan", "sanjeewa"))).build()).then(WorkUnit.of("work2", new Work2("work2")).build()).then(WorkUnit.of("work3", new Work2("work3")).build()).then(WorkUnit.waitFor("work6")).then(ParallelWorkflow.name("parrallal").execute(WorkUnit.of("work4", new Work2("work4-parallel")).build()).execute(WorkUnit.of("work5", new Work2("work5-parallel")).build()).build()).build();
        WorkflowEngine engine = new WorkflowEngine("1");
        engine.execute(sequence).subscribe();
        Thread.sleep(5000L);
        engine.executeAsync("work6", t -> Mono.just((Object)"hello")).doOnError(err -> ((Throwable)Throwable.class.cast(err)).printStackTrace()).doOnNext(s -> System.out.println("s: " + s)).subscribe();
        engine.executeAsync("work6", t -> Mono.just((Object)"hello")).doOnError(err -> ((Throwable)Throwable.class.cast(err)).printStackTrace()).doOnNext(s -> System.out.println("s: " + s)).subscribe();
        System.out.println("---------------------------");
        SequentialWorkflow seq1 = SequentialWorkflow.name("seq1").execute(WorkUnit.of("work1-seq1", new Work2("work1-seq1")).build()).then(WorkUnit.of("work2-seq1", new Work2("work2-seq1")).build()).build();
        SequentialWorkflow seq2 = SequentialWorkflow.name("seq2").execute(WorkUnit.of("work1-seq2", new Work2("work1-seq2")).build()).then(WorkUnit.of("work2-seq2", new Work2("work2-seq2")).build()).build();
        ParallelWorkflow parallal = ParallelWorkflow.name("parrallel1").execute(seq1, seq2).build();
        engine = new WorkflowEngine("1");
        engine.execute(parallal).subscribe();
        Thread.sleep(10000000L);
    }

    static class Test {
        Map<String, AtomicReference<Work.Status>> stats = new HashMap<String, AtomicReference<Work.Status>>();

        public Test() {
            this.stats.put("asfas", new AtomicReference<Work.Status>(Work.Status.PENDING));
        }
    }

    public static class Work2
    implements Work {
        private List<String> msg;

        public Work2(List<String> msg) {
            this.msg = msg;
        }

        public Work2(String msg) {
            this.msg = Collections.singletonList(msg);
        }

        @Override
        public Mono<WorkStatus> execute(WorkContext context) {
            System.out.println(this.msg + " executed Thread : " + Thread.currentThread().getName());
            return Mono.just((Object)WorkStatus.publish(Work.Status.COMPLETED, context));
        }
    }

    public static class Work1
    implements Work {
        @Override
        public Mono<WorkStatus> execute(WorkContext context) {
            System.out.println("work1  executed Thread : " + Thread.currentThread().getName());
            return Mono.just((Object)WorkStatus.publish(Work.Status.COMPLETED, context));
        }
    }
}

