/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.workflow;

import com.cloudimpl.outstack.runtime.util.Util;
import com.cloudimpl.outstack.workflow.AbstractWork;
import com.cloudimpl.outstack.workflow.Work;
import com.cloudimpl.outstack.workflow.WorkContext;
import com.cloudimpl.outstack.workflow.WorkPredicate;
import com.cloudimpl.outstack.workflow.WorkStatus;
import com.cloudimpl.outstack.workflow.Workflow;
import com.cloudimpl.outstack.workflow.WorkflowEngine;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class PredicateWorkflow
extends Workflow {
    private static final Logger log = LoggerFactory.getLogger(PredicateWorkflow.class);
    private final Class<? extends WorkPredicate> predicateType;
    private final AbstractWork then;
    private final AbstractWork otherwise;

    private PredicateWorkflow(String id, String name, Class<? extends WorkPredicate> predicate, AbstractWork then, AbstractWork otherwise) {
        super(id, name);
        this.predicateType = predicate;
        this.then = then;
        this.otherwise = otherwise;
    }

    @Override
    public Mono<WorkStatus> execute(WorkContext context) {
        WorkPredicate predicate = (WorkPredicate)Util.createObject(this.predicateType, (Util.VarArg)new Util.VarArg((Object[])new Class[0]), (Util.VarArg)new Util.VarArg(new Object[0]));
        this.log("started", new Object[0]);
        return Mono.just((Object)predicate.apply(context)).filter(b -> b).flatMap(b -> this.then.execute(context)).switchIfEmpty(Mono.defer(() -> Mono.just((Object)this.otherwise).flatMap(o -> o.execute(context))));
    }

    protected static Builder name(String name) {
        return new Builder(name);
    }

    @Override
    protected void setEngine(WorkflowEngine engine) {
        this.engine = engine;
        this.then.setEngine(engine);
        this.otherwise.setEngine(engine);
    }

    @Override
    protected void setHandlers(BiFunction<String, WorkStatus, Mono<WorkStatus>> updateStateHandler, Consumer<Object> autoWireHandler, Function<String, Optional<WorkStatus>> workStatusLoader) {
        super.setHandlers(updateStateHandler, autoWireHandler, workStatusLoader);
        this.then.setHandlers(updateStateHandler, autoWireHandler, workStatusLoader);
        this.otherwise.setHandlers(updateStateHandler, autoWireHandler, workStatusLoader);
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("id", this.getId());
        json.addProperty("workflowType", PredicateWorkflow.class.getName());
        json.addProperty("name", this.name);
        json.addProperty("predicateType", this.predicateType.getName());
        json.add("then", (JsonElement)this.then.toJson());
        json.add("otherwise", (JsonElement)this.otherwise.toJson());
        return json;
    }

    public static PredicateWorkflow fromJson(JsonObject json) {
        return new PredicateWorkflow(json.get("id").getAsString(), json.get("name").getAsString(), Util.classForName((String)json.get("predicateType").getAsString()), AbstractWork.fromJson(json.getAsJsonObject("then")), AbstractWork.fromJson(json.getAsJsonObject("otherwise")));
    }

    public static final class Builder {
        private final String name;
        private String predicateName;
        private AbstractWork then;
        private AbstractWork otherwise;

        public Builder(String name) {
            this.name = name;
        }

        public ThenStep when(String workPredicate) {
            return new ThenStep(this);
        }
    }

    public static final class BuildStep {
        private final Builder builder;

        public BuildStep(Builder builder) {
            this.builder = builder;
        }

        public PredicateWorkflow build() {
            return new PredicateWorkflow(Work.generateId(), this.builder.name, (Class)WorkPredicate.from(this.builder.predicateName), this.builder.then, this.builder.otherwise);
        }
    }

    public static final class OtherwiseStep {
        private final Builder builder;

        public OtherwiseStep(Builder builder) {
            this.builder = builder;
        }

        public BuildStep otherwise(AbstractWork work) {
            this.builder.otherwise = work;
            return new BuildStep(this.builder);
        }
    }

    public static final class ThenStep {
        private Builder builder;

        public ThenStep(Builder builder) {
            this.builder = builder;
        }

        public OtherwiseStep then(AbstractWork work) {
            this.builder.then = work;
            return new OtherwiseStep(this.builder);
        }
    }
}

