/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.workflow;

import com.cloudimpl.outstack.workflow.StatefullWork;
import com.cloudimpl.outstack.workflow.Work;
import com.cloudimpl.outstack.workflow.WorkContext;
import com.cloudimpl.outstack.workflow.WorkStatus;
import com.cloudimpl.outstack.workflow.WorkUnit;
import com.cloudimpl.outstack.workflow.WorkflowException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class ExternalTrigger
implements StatefullWork {
    private static final Logger log = LoggerFactory.getLogger(ExternalTrigger.class);
    private CompletableFuture<WorkStatus> future = new CompletableFuture();
    private WorkContext context;
    protected transient WorkUnit workUnit;
    private Map<String, String> labels = new HashMap<String, String>();
    private final boolean isGate;

    protected ExternalTrigger() {
        this.isGate = false;
    }

    protected ExternalTrigger(boolean isGate) {
        this.isGate = isGate;
    }

    protected void init(WorkUnit workUnit) {
        this.workUnit = workUnit;
    }

    protected void setFuture(CompletableFuture<WorkStatus> future) {
        this.future = future;
    }

    public ExternalTrigger putLabel(Map<String, String> labels) {
        this.labels = labels;
        return this;
    }

    public boolean isGate() {
        return this.isGate;
    }

    protected WorkUnit getWorkUnit() {
        return this.workUnit;
    }

    @Override
    public Mono<WorkStatus> execute(WorkContext context) {
        this.context = context;
        this.labels.entrySet().stream().forEach(e -> this.context.putLabel((String)e.getKey(), (String)e.getValue()));
        return Mono.fromFuture(this.future);
    }

    public synchronized <T> Mono<T> triggerAsync(Function<WorkContext, Mono<Object>> handler) {
        if (!this.isGate && this.context == null) {
            return Mono.error((Throwable)new WorkflowException("External trigger {0} not active yet", this.getClass().getName()));
        }
        WorkContext ctx = this.context == null ? new WorkContext().clone(true) : this.context;
        Mono<Object> out = handler.apply(ctx);
        AtomicReference<Work.Status> reference = new AtomicReference<Work.Status>(Work.Status.COMPLETED);
        return out.map(o -> this.mapOutCome(o, reference)).doOnSuccess(o -> this.future.complete(WorkStatus.publish((Work.Status)((Object)((Object)reference.get())), ctx)));
    }

    public synchronized <T> T trigger(Function<WorkContext, Object> handler) {
        if (!this.isGate && this.context == null) {
            throw new WorkflowException("External trigger {0} not active yet", this.getClass().getName());
        }
        WorkContext ctx = this.context == null ? new WorkContext().clone(true) : this.context;
        Object out = handler.apply(ctx);
        AtomicReference<Work.Status> reference = new AtomicReference<Work.Status>(Work.Status.COMPLETED);
        T ret = this.mapOutCome(out, reference);
        this.checkWaitAndPublish(reference, ctx);
        return ret;
    }

    public void cancel(WorkContext context) {
        this.workUnit.log("external trigger cancel invoked", new Object[0]);
        this.future.complete(WorkStatus.publish(Work.Status.CANCELLED, context));
    }

    private <T> T mapOutCome(Object obj, AtomicReference<Work.Status> reference) {
        if (obj instanceof WorkStatus) {
            WorkStatus st = (WorkStatus)WorkStatus.class.cast(obj);
            reference.set(st.getStatus());
            return st.getData();
        }
        return (T)obj;
    }

    private void checkWaitAndPublish(AtomicReference<Work.Status> reference, WorkContext context) {
        if (reference.get() != Work.Status.WAIT) {
            this.future.complete(WorkStatus.publish(reference.get(), context));
        }
    }
}

