/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.workflow;

import com.cloudimpl.outstack.common.GsonCodec;
import com.cloudimpl.outstack.workflow.Work;
import com.cloudimpl.outstack.workflow.WorkflowException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

public class WorkContext {
    private final Map<String, List<String>> attr;
    private final Map<String, AtomicReference<Work.Status>> mapStatus;
    private final transient List<Commit> commits = new LinkedList<Commit>();
    private transient Map<String, String> labels = new HashMap<String, String>();
    private transient boolean immutable;

    protected WorkContext() {
        this.attr = new ConcurrentHashMap<String, List<String>>();
        this.mapStatus = new ConcurrentHashMap<String, AtomicReference<Work.Status>>();
        this.immutable = false;
    }

    private WorkContext(boolean immutable, Map<String, List<String>> contexts, Map<String, AtomicReference<Work.Status>> mapStatus) {
        this.immutable = immutable;
        this.attr = contexts;
        this.mapStatus = new ConcurrentHashMap<String, AtomicReference<Work.Status>>();
        mapStatus.entrySet().forEach(e -> this.mapStatus.put((String)e.getKey(), new AtomicReference<Work.Status>((Work.Status)((Object)((Object)((AtomicReference)e.getValue()).get())))));
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public void put(String key, boolean value) {
        this.put(key, String.valueOf(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String key, String value) {
        List<Commit> list;
        if (this.immutable) {
            throw new WorkflowException("context is not mutable", new Object[0]);
        }
        List<Commit> list2 = list = this.attr.computeIfAbsent(key, k -> new LinkedList());
        synchronized (list2) {
            list.add((Commit)((Object)value));
        }
        list2 = this.commits;
        synchronized (list2) {
            this.commits.add(new Commit(key, value));
        }
    }

    public String getLabel(String name) {
        return this.labels.get(name);
    }

    protected void putLabel(String name, String value) {
        this.labels.put(name, value);
    }

    public AtomicReference<Work.Status> getStatus(String id) {
        return this.mapStatus.computeIfAbsent(id, i -> new AtomicReference<Work.Status>(Work.Status.PENDING));
    }

    public void put(String key, int value) {
        this.put(key, String.valueOf(value));
    }

    public void put(String key, long value) {
        this.put(key, String.valueOf(value));
    }

    public void put(String key, float value) {
        this.put(key, String.valueOf(value));
    }

    public void put(String key, double value) {
        this.put(key, String.valueOf(value));
    }

    public boolean getBoolean(String key) {
        return Boolean.valueOf(this.attr.getOrDefault(key, Collections.singletonList("false")).get(0));
    }

    public String getString(String key) {
        List list = this.attr.getOrDefault(key, null);
        if (list == null) {
            return null;
        }
        return (String)list.get(0);
    }

    public int getInt(String key) {
        return Integer.valueOf(this.attr.getOrDefault(key, Collections.singletonList("0")).get(0));
    }

    public long getLong(String key) {
        return Long.valueOf(this.attr.getOrDefault(key, Collections.singletonList("0L")).get(0));
    }

    public float getFloat(String key) {
        return Float.valueOf(this.attr.getOrDefault(key, Collections.singletonList("0.0f")).get(0)).floatValue();
    }

    public double getDouble(String key) {
        return Double.valueOf(this.attr.getOrDefault(key, Collections.singletonList("0.0d")).get(0));
    }

    public void merge(WorkContext context) {
        if (context == null || context == this) {
            throw new WorkflowException("invalid argument", new Object[0]);
        }
        context.commits.forEach(c -> this.put(c.getKey(), c.getValue()));
        context.mapStatus.entrySet().forEach(e -> this.mapStatus.put((String)e.getKey(), (AtomicReference)e.getValue()));
    }

    protected WorkContext clone(boolean immutable) {
        ConcurrentHashMap<String, List<String>> attr2 = new ConcurrentHashMap<String, List<String>>();
        this.attr.entrySet().forEach(e -> attr2.put((String)e.getKey(), new LinkedList((Collection)e.getValue())));
        return new WorkContext(immutable, attr2, this.mapStatus);
    }

    public String toString() {
        return GsonCodec.encode((Object)this);
    }

    public static final class Commit {
        private String key;
        private String value;

        public Commit(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }
}

