/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.workflow;

import com.cloudimpl.outstack.workflow.Work;
import com.cloudimpl.outstack.workflow.WorkContext;
import com.cloudimpl.outstack.workflow.WorkflowException;

public class WorkStatus {
    private final Work.Status status;
    private Object data;
    private String id;

    private WorkStatus(Work.Status status) {
        this.status = status;
    }

    public static WorkStatus publish(Work.Status status) {
        return WorkStatus.publish(status, null);
    }

    public static WorkStatus publish(Work.Status status, Object data) {
        if (status == Work.Status.PENDING || status == Work.Status.RUNNING) {
            throw new WorkflowException("invalid work status {0} published", new Object[]{status});
        }
        return new WorkStatus(status).setContext(data);
    }

    protected WorkStatus setContext(Object data) {
        this.data = data;
        return this;
    }

    public <T> T getData() {
        return (T)this.data;
    }

    public WorkContext getAsWorkContext() {
        return (WorkContext)this.data;
    }

    public Work.Status getStatus() {
        return this.status;
    }

    public String toString() {
        return "WorkStatus{status=" + this.status + ", data=" + this.data + "}";
    }
}

