/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.workflow.domain;

import com.cloudimpl.outstack.runtime.domainspec.DomainEventException;
import com.cloudimpl.outstack.runtime.domainspec.EntityMeta;
import com.cloudimpl.outstack.runtime.domainspec.Event;
import com.cloudimpl.outstack.runtime.domainspec.ITenantOptional;
import com.cloudimpl.outstack.runtime.domainspec.Id;
import com.cloudimpl.outstack.runtime.domainspec.RootEntity;
import com.cloudimpl.outstack.workflow.Work;
import com.cloudimpl.outstack.workflow.WorkContext;
import com.cloudimpl.outstack.workflow.WorkStatus;
import com.cloudimpl.outstack.workflow.domain.WorkflowCompleted;
import com.cloudimpl.outstack.workflow.domain.WorkflowCreated;
import com.cloudimpl.outstack.workflow.domain.WorkflowResultUpdated;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

@EntityMeta(plural="workflows", version="v1")
public class WorkflowEntity
extends RootEntity
implements ITenantOptional {
    @Id
    private String workflowId;
    private String content;
    private Work.Status status;
    private String tenantId;
    private Map<String, WorkContext> results;

    public WorkflowEntity(String workflowId, String tenantId) {
        this.workflowId = workflowId;
        this.tenantId = tenantId;
        this.status = Work.Status.PENDING;
        this.results = new LinkedHashMap<String, WorkContext>();
    }

    public String entityId() {
        return this.workflowId;
    }

    public Work.Status getStatus() {
        return this.status;
    }

    public String getContent() {
        return this.content;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public Optional<WorkStatus> getStatus(String workId) {
        WorkContext ctx = this.results.get(workId);
        if (ctx != null) {
            return Optional.of(WorkStatus.publish(ctx.getStatus(workId).get(), ctx));
        }
        return Optional.empty();
    }

    private void applyEvent(WorkflowCreated evt) {
        this.workflowId = evt.getWorkflowId();
        this.content = evt.getContent();
        this.status = evt.getStatus();
    }

    private void applyEvent(WorkflowResultUpdated evt) {
        this.results.put(evt.getWorkId(), evt.getContext());
    }

    private void applyEvent(WorkflowCompleted evt) {
        this.status = evt.getStatus();
    }

    protected void apply(Event event) {
        switch (event.getClass().getSimpleName()) {
            case "WorkflowCreated": {
                this.applyEvent((WorkflowCreated)event);
                break;
            }
            case "WorkflowResultUpdated": {
                this.applyEvent((WorkflowResultUpdated)event);
                break;
            }
            case "WorkflowCompleted": {
                this.applyEvent((WorkflowCompleted)event);
                break;
            }
            default: {
                throw new DomainEventException(DomainEventException.ErrorCode.UNHANDLED_EVENT, "unhandled event:" + event.getClass().getName(), new Object[0]);
            }
        }
    }

    public String idField() {
        return "name";
    }
}

