/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.workflow;

import com.cloudimpl.outstack.workflow.AbstractWork;
import com.cloudimpl.outstack.workflow.Work;
import com.cloudimpl.outstack.workflow.WorkContext;
import com.cloudimpl.outstack.workflow.WorkStatus;
import com.cloudimpl.outstack.workflow.Workflow;
import com.cloudimpl.outstack.workflow.WorkflowEngine;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class ParallelWorkflow
extends Workflow {
    private final List<AbstractWork> workUnits;

    private ParallelWorkflow(String id, String name, List<AbstractWork> works) {
        super(id, name);
        this.workUnits = Collections.unmodifiableList(works);
    }

    @Override
    public Mono<WorkStatus> execute(WorkContext context) {
        WorkContext copy = context.clone(false);
        this.log("started", new Object[0]);
        return Flux.fromIterable(this.workUnits).parallel(Runtime.getRuntime().availableProcessors()).runOn(Schedulers.parallel()).flatMap(wk -> this.retryWrap((Work)wk, copy)).sequential().collectList().map(l -> this.merge(WorkStatus.publish(Work.Status.COMPLETED, copy), (List<WorkStatus>)l)).doOnNext(r -> this.log("done : {0}", new Object[]{r.getStatus()}));
    }

    @Override
    protected void setEngine(WorkflowEngine engine) {
        this.engine = engine;
        this.workUnits.forEach(w -> w.setEngine(engine));
    }

    @Override
    protected void setHandlers(BiFunction<String, WorkStatus, Mono<WorkStatus>> updateStateHandler, Consumer<Object> autoWireHandler, Function<String, Optional<WorkStatus>> workStatusLoader) {
        super.setHandlers(updateStateHandler, autoWireHandler, workStatusLoader);
        this.workUnits.forEach(w -> w.setHandlers(updateStateHandler, autoWireHandler, workStatusLoader));
    }

    public static ExecuteStep name(String name) {
        Builder builder = new Builder(name);
        return new ExecuteStep(builder);
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("id", this.getId());
        json.addProperty("workflowType", ParallelWorkflow.class.getName());
        json.addProperty("name", this.name);
        JsonArray arr = new JsonArray();
        this.workUnits.stream().forEach(w -> arr.add((JsonElement)w.toJson()));
        json.add("workUnits", (JsonElement)arr);
        return json;
    }

    public static ParallelWorkflow fromJson(JsonObject json) {
        JsonArray arr = json.getAsJsonArray("workUnits");
        LinkedList<AbstractWork> workunits = new LinkedList<AbstractWork>();
        arr.forEach(w -> workunits.add(AbstractWork.fromJson(w.getAsJsonObject())));
        ParallelWorkflow workflow = new ParallelWorkflow(json.get("id").getAsString(), json.get("name").getAsString(), workunits);
        return workflow;
    }

    public static final class Builder {
        private final List<AbstractWork> works = new LinkedList<AbstractWork>();
        private String name;

        public Builder(String name) {
            this.name = name;
        }
    }

    public static final class ExecuteStep {
        private final Builder builder;

        public ExecuteStep(Builder builder) {
            this.builder = builder;
        }

        public ExecuteStep execute(AbstractWork ... works) {
            Arrays.asList(works).forEach(w -> this.builder.works.add((AbstractWork)w));
            return this;
        }

        public ParallelWorkflow build() {
            return new ParallelWorkflow(Work.generateId(), this.builder.name, this.builder.works);
        }
    }
}

