/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary.android;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;

public class MultipartUtility {
    private final String boundary;
    private static final String LINE_FEED = "\r\n";
    private static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    private HttpURLConnection httpConn;
    private String charset;
    private OutputStream outputStream;
    private PrintWriter writer;
    public static final String USER_AGENT = "CloudinaryAndroid/1.5.0";

    public MultipartUtility(String requestURL, String charset, String boundary, Map<String, String> headers) throws IOException {
        this.charset = charset;
        this.boundary = boundary;
        URL url = new URL(requestURL);
        this.httpConn = (HttpURLConnection)url.openConnection();
        this.httpConn.setDoOutput(true);
        this.httpConn.setDoInput(true);
        if (headers != null) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                this.httpConn.setRequestProperty(header.getKey(), header.getValue());
            }
        }
        this.httpConn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
        this.httpConn.setRequestProperty("User-Agent", USER_AGENT);
        this.outputStream = this.httpConn.getOutputStream();
        this.writer = new PrintWriter((Writer)new OutputStreamWriter(this.outputStream, charset), true);
    }

    public MultipartUtility(String requestURL, String charset, String boundary) throws IOException {
        this(requestURL, charset, boundary, null);
    }

    public void addFormField(String name, String value) {
        this.writer.append("--" + this.boundary).append(LINE_FEED);
        this.writer.append("Content-Disposition: form-data; name=\"" + name + "\"").append(LINE_FEED);
        this.writer.append("Content-Type: text/plain; charset=" + this.charset).append(LINE_FEED);
        this.writer.append(LINE_FEED);
        this.writer.append(value).append(LINE_FEED);
        this.writer.flush();
    }

    public void addFilePart(String fieldName, File uploadFile, String fileName) throws IOException {
        if (fileName == null) {
            fileName = uploadFile.getName();
        }
        FileInputStream inputStream = new FileInputStream(uploadFile);
        this.addFilePart(fieldName, inputStream, fileName);
    }

    public void addFilePart(String fieldName, File uploadFile) throws IOException {
        this.addFilePart(fieldName, uploadFile, "file");
    }

    public void addFilePart(String fieldName, InputStream inputStream, String fileName) throws IOException {
        if (fileName == null) {
            fileName = "file";
        }
        this.writer.append("--" + this.boundary).append(LINE_FEED);
        this.writer.append("Content-Disposition: form-data; name=\"" + fieldName + "\"; filename=\"" + fileName + "\"").append(LINE_FEED);
        this.writer.append("Content-Type: ").append(APPLICATION_OCTET_STREAM).append(LINE_FEED);
        this.writer.append("Content-Transfer-Encoding: binary").append(LINE_FEED);
        this.writer.append(LINE_FEED);
        this.writer.flush();
        byte[] buffer = new byte[4096];
        int bytesRead = -1;
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            this.outputStream.write(buffer, 0, bytesRead);
        }
        this.outputStream.flush();
        inputStream.close();
        this.writer.append(LINE_FEED);
        this.writer.flush();
    }

    public void addFilePart(String fieldName, InputStream inputStream) throws IOException {
        this.addFilePart(fieldName, inputStream, "file");
    }

    public HttpURLConnection execute() throws IOException {
        this.writer.append("--" + this.boundary + "--").append(LINE_FEED);
        this.writer.close();
        return this.httpConn;
    }
}

