/*
 * Decompiled with CFR 0.152.
 */
package com.clumd.projects.javajson.api;

import com.clumd.projects.javajson.api.Json;
import com.clumd.projects.javajson.api.JsonGenerator;
import com.clumd.projects.javajson.core.JsonTape;
import com.clumd.projects.javajson.exceptions.JsonException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class JsonParser {
    private JsonParser() {
    }

    public static Json parse(String jsonAsString) throws JsonException {
        return new JsonTape(jsonAsString).parseNextElement();
    }

    public static Json parse(Collection<String> jsonAsStringCollection) throws JsonException {
        StringBuilder whole = new StringBuilder();
        for (String s : jsonAsStringCollection) {
            whole.append(s);
        }
        return JsonParser.parse(whole.toString());
    }

    public static Json parse(String[] jsonAsStringArray) throws JsonException {
        StringBuilder whole = new StringBuilder();
        for (String s : jsonAsStringArray) {
            whole.append(s);
        }
        return JsonParser.parse(whole.toString());
    }

    public static Json parse(JsonGenerator jsonable) throws JsonException {
        return jsonable.convertToJSON();
    }

    public static List<Json> parseMultipleStrings(Collection<String> multipleJsonAsStrings) throws JsonException {
        ArrayList<Json> jsons = new ArrayList<Json>(multipleJsonAsStrings.size());
        for (String s : multipleJsonAsStrings) {
            jsons.add(JsonParser.parse(s));
        }
        return jsons;
    }

    public static List<Json> parseMultipleJSONables(Collection<JsonGenerator> multipleJsonAsGenerators) throws JsonException {
        ArrayList<Json> jsons = new ArrayList<Json>(multipleJsonAsGenerators.size());
        for (JsonGenerator s : multipleJsonAsGenerators) {
            jsons.add(s.convertToJSON());
        }
        return jsons;
    }

    public static Set<Json> parseMultipleStringsForDistinct(Collection<String> multipleJsonAsStrings) throws JsonException {
        HashSet<Json> jsons = new HashSet<Json>(multipleJsonAsStrings.size());
        for (String s : multipleJsonAsStrings) {
            jsons.add(JsonParser.parse(s));
        }
        return jsons;
    }

    public static Set<Json> parseMultipleJSONablesForDistinct(Collection<JsonGenerator> multipleJsonAsGenerators) throws JsonException {
        HashSet<Json> jsons = new HashSet<Json>(multipleJsonAsGenerators.size());
        for (JsonGenerator s : multipleJsonAsGenerators) {
            jsons.add(s.convertToJSON());
        }
        return jsons;
    }
}

