/*
 * Decompiled with CFR 0.152.
 */
package com.clumd.projects.javajson.core;

import com.clumd.projects.javajson.core.KeyTape;
import com.clumd.projects.javajson.exceptions.json.JsonKeyException;

final class BuilderKeyTape
extends KeyTape {
    BuilderKeyTape(String fullInput) {
        super(fullInput);
    }

    @Override
    protected String validateDeclaredArrayIndex(int startingIndex) {
        int arrayIndex;
        try {
            String indexRegion = this.requestRegion(startingIndex, this.getCurrentIndex());
            if (indexRegion.equals("")) {
                this.terminateArrayAccessorInChain();
                return "[append";
            }
            arrayIndex = Integer.parseInt(indexRegion);
        }
        catch (NumberFormatException e) {
            throw (JsonKeyException)this.createParseErrorFromOffset(startingIndex - this.getCurrentIndex(), "<positive integer>", "Failed to parse array accessor in key. Element was not a valid integer.");
        }
        if (arrayIndex < 0) {
            throw (JsonKeyException)this.createParseErrorFromOffset(startingIndex - this.getCurrentIndex(), "<positive integer>", "Array accessor in key was negative integer. Must be positive.");
        }
        this.terminateArrayAccessorInChain();
        return "[" + String.valueOf(arrayIndex);
    }

    private void terminateArrayAccessorInChain() {
        this.consumeOne();
        if (this.currentIndex < this.fullInput.length()) {
            this.validateTrailingArrayElements();
        }
    }
}

